Secondly, there are also the so-called probabilistic extensions to Description Logics (DL) that want to be seen as an alternative to more traditional Bayesian approaches. For instance, Pronto [7] is a probabilistic DL reasoner prototype. Pronto is able to represent and reason about uncertainty in both, generic background knowledge and individual facts (respectively probabilistic relationships between OWL classes and relationships between an OWL 
class and an individual). We could note that Pronto uses OWL version 1.1 axiom annotations (which is however not a W3C recommendation) to associate probability intervals with uncertain OWL axioms. The main advantages are clearly the ease of the representation and of the reasoner manipulation. However this tool presents really serious deficiencies, considering its scalability and speed of processing. Most notably, Pronto's performance does not scale past beyond around 15 generic conditional constraints in an OWL knowledge base. 

Finally, there are also probabilistic approaches that rely on first-order logic such as PR-OWL [8] in combination with UnBBayes-MEBN. PR-OWL is an upper ontology. In order to use it, one has to import the PR-OWL ontology into an ontology editor (e.g. Protégé). Then one can start constructing our domain-specific concepts using the PROWL definitions to represent uncertainty about their attributes and relationships according to the Multi-Entity Bayesian Network (MEBN) model. A graphical user interface (UnBBayes-MEBN) is also available to make it easier to instantiate the main ontological concepts (M-Frags, Resident, Input, Context Nodes, etc). UnBBayes-MEBN implements also a reasoner based on the PR-OWL/MEBN
framework. Unfortunately, this GUI has a General Public License (GPL) which is a little too restrictive in order to integrate it into a commercial application. In addition, to our knowledge MEBN community is not wide enough to be considered as an emerging standard. Thus it represents a major difficulty to manipulate this tool. 

## C. Fuzzy Approaches

Fuzzy formalisms allow the representation and the gradual assessment of truth about vague information. 

FuzzyDL [10] is one of the most succeeded tools that propose a fuzzy description language associated to a reasoning engine. Even if the syntax is based on fuzzy SHIF, we can translate a basic ontology into a fuzzyDL file, thanks to a given specific API. Then fuzzy statements can be added to this file, or we can directly make use of the fuzzyOntology. The latter is an OWL ontology that may be used to encode Fuzzy OWL statements and thanks to a parser, it can be translated into a fuzzyDL file. Finally, it supports two types of reasoning: Zadeh semantics and Lukasiewicz Logic. However, we could point out that the implementation is only intended to be run either on MacOSX or Linux. 

D. *Dempster-Shafer Approaches* Dempster–Shafer theory [11], also known as the theory of evidence or the theory of belief functions, was developed by Glenn Shafer in 1975 after the work made by Arthur P. Dempster. Beliefs in a hypothesis are calculated as the sum of the masses of all sets it encloses. It is often presented as a generalization of the probability theory. Briefly, it allows combining evidence from different sources and arriving at a degree of belief (represented by a belief function) that takes into account all the available evidence. 

Regarding ontology, it has been yet most applied in areas such as inconsistency handling in OWL ontologies and ontology mapping ([14] and [15]). These areas start from the hypothesis that ontologies do not handle uncertainty, but produce uncertainty when grouping together a set of ontologies. However, one could notice that very recently a new approach [16] has been presented, which does not deal with ontology mapping or inconsistencies; it focuses rather on translating an OWL taxonomy into a directed evidential network based on the evidence theory. However, it deals only with classes and none open source tool is yet being available to test it. 

## Iii. Modeling And Reasoning On Dempster-Shafer Theory

 We are now going to introduce the obvious advantages of the theory of belief functions that lead us to seek a tool, which implements this theory. However, following this brief state of art, there is currently and to our knowledge no available tool based on Dempster-Shafer theory that meets our purposes that is to say to represent and reason about the uncertainty contained in our data/information. 

## A. Advantages Of Dempster-Shafer Theory

Inside the theory of uncertainty representation, we encountered an important difficulty when trying these tools in regards to the type of knowledge available in input of data fusion applications. As a matter of fact, the representation of information absence is badly taken into account by the theory of probability. Indeed, prior and conditional probabilities need to be specified into probabilistic methods. This requirement often lead in using a symmetry (minimax error) argument to assign prior probabilities to random variables (e.g. assigning 0.5 to binary values for which no information is available about which is more likely). However, any information contained in the missing priors and conditionals is not used in the Dempster–Shafer framework unless it can be obtained indirectly - and arguably is then available for calculation using Bayes equations. 

One of the major advantages of Dempster–Shafer theory over probability theory is thus to allow one to specify a degree of ignorance in a situation instead of being forced to supply prior probabilities. This ability to explicitly model the degree of ignorance makes the theory very appealing. 