Uncertain_concept, linked to the three previously mentioned instances. The universal set whose definition is the set of all states under consideration is actually given by the list of instances linked to a specific instance of *Uncertain_concept*. 

There is one *DS_concept* instance associated to each hypothesis, or composite hypotheses, thanks to the object property *DS_relation*. A *DS_concept* has datatype property: 
DS_source, which cardinality equals to 1. In other words, for each DS_concept, there is one DS_source associated. We proposed here to symbolize the source by a string (source "A", for instance). Then it also has the following properties: *DS_mass, DS_belief* and *DS_plausibility*, which have for value a double, which is implicitly ranging from 0 to 1. If we recall our initial use case for sensor A when dealing with the composite hypotheses {tank_i, tank_j}, the two instances of military tank will point to the same DS_concept object which has for *DS_source*: A and we assume for *DS_mass*: 0.6. A unique *DS_concept* will be linked with *DS_relation* to more or less instances according to the imprecision handled by the sensor. 

Finally, we can finish filling in our domain ontology with instances that are not uncertain by the classical method, or when a certain instance is being involved in a relation that has for domain or range an uncertain concept, we bind it to the adequate instance of *Uncertain_concept*. 

The following figure gives an outline of the instances that 

![0_image_0.png](0_image_0.png)

instance of *Uncertain_concept* thanks to the relation: 
is_either. Then, we associate them to a *DS_concept* (thanks to *DS_relation*) and we can here declare which is the source that has made this observation and what is the value of mass, the belief or credibility that is associated to it.

C. *Reasoning on uncertain ontological aspects* Once having a unique general representation of DempsterShafer for any field, it has been quite easy to implement a Java application based on Jena framework that enables us to reason automatically about the uncertain objects contained in the ontology. Jena is an open source Java framework for building Semantic Web applications. It provides indeed a programmatic environment for RDF, RDFS and OWL, 
SPARQL and includes a rule-based inference engine. In our application, the Jena framework is a tool to retrieve the instances associated to each individual uncertain concept, and the Dempster-Shafer information collected. This information is then transmitted to a common basic Dempster-Shafer library [17] which then performs calculations in the Dempster-Shafer theory. In other words, our Java application first maps our ontology-based annotation (the set of related instances, for example those represented in Figure 3), written in OWL, into a Java representation of the Dempster-Shafer theory (according here to the Java library of [17]). Then this library enables us to manipulate the numerical values (mass, credibility, plausibility) which were previously contained in the annotation in order to perform classical calculations (conjunctive/disjunctive combination, conditioning, pignistic transformation, several uncertainty measures). As a matter of fact, our application calculates K, which represents the measure of the amount of conflict between mass sets. 

According to the value of K, we combine evidence from different sources, i.e. we combine the independent sets of mass assignments, thanks to Dempster's rule of combination. Finally, decision criteria can be applied to extract the chosen hypothesis, either based on the maximum of plausibility or belief function or either on pignistic probability criteria, etc. 

in regards to the type of problem handled. 

As a consequence, the application creates a mapping between ontology representation and the Dempster-Shafer model which enables to reason about uncertainty in ontology. 

## D. Advantages, Limits And Future Work

For the moment, we have a simple mechanism to instantiate our domain ontology in an uncertain manner by importing the Dempster-Shafer ontology. 

The advantage of this method is that one can come with any domain ontology and instantiate it, without making any change in this ontology. This is mostly due to the fact that OWL is a structured language but flexible enough to overcome the strict definition of properties which restricts the value of the range or domain to some given classes. What we mean is that without this flexibility, we would have 