to modify slightly the original ontology during the last phase of instantiation of certain classes in relation to instance of uncertain concept. Indeed, it would be impossible to link a property to an instance of *Uncertain_concept* (in the role of range or domain) since this class does not appear in the property definition in the domain ontology. Therefore we would have to add that the relation can accept for domain (or for range) an instance of *Uncertain_concept*. However, even if this is accepted by the syntax, it lowers naturally a little the expressivity of the ontology. 

Future work can carry about the representation of uncertainty within relations (between concepts or between a concept and data value) in ontology. 

Moreover, in a near future, we are also interested in using some reasoning capabilities of OWL language instead of simply use the ontology as a mean to represent the observations (observed entity and mass value, belief and/or plausibility associated to it) carried out by independent sources. As a matter of fact, OWL enables us, for example, to link resources which are instances of equivalent concepts defined under different labels ("owl:equivalentClass") or to reference a single individual using different names ("owl:sameAs"). Sources can thus use different ways to refer to identical resources. Therefore it would be conceivable to take them into account while applying the Dempster's rule of combination when these specific OWL properties are met in the domain ontology. In the same way, we could also enlarge this reasoning to the taxonomy of the ontology, by including the notion of semantic distance between two concepts. 

Indeed, two entities observed by different sources that are quite similar in nature (i.e. "closed" in the taxonomy) should have their belief augmented in comparison to a single entity observed, which is far from the others. Further work is needed in that field but a rule language (e.g. Jena rules [5], SWRL [18], RIF [19], etc.) could be used in order to perform those changes of mass values. 

For other purposes, it could also be imagined that the application, which has an uncertain ontology for input, returns a non uncertain ontology, i.e. a traditional ontology, which would be the result of the Dempster's rule of combination, followed by a decision process on single hypothesis. However, for Data Fusion applications, it is preferable to keep this representation of uncertainty. 

## Iv. Conclusion

To conclude, let's remind that Data Fusion is the art of managing many pieces of information that are imperfect in multiple ways and to provide at the end a clearer view of the situation, that is to say less uncertain. Therefore there is currently a serious deficiency in ontological capacities. Thus, we have seen that uncertainty extension to OWL has started to make great strides in the last few years. We have proposed in this paper a simple approach to address the problem of representing uncertainty, based on the evidential approach. We have presented a mechanism to instantiate our domain ontology thanks to the DS-Ontology. The advantage of this method is that one can come with any domain ontology and instantiate it in an uncertain manner, without making any change in the domain ontology. 

## Acknowledgment

We are grateful to Arnaud Saval and Khaled Khelif for their comments and hope that the revised paper has addressed their concerns. 

## References

[1] David L. Hall, James Llinas, *Handbook of Multisensor Data Fusion*, 
CRC Press LLC, 2001. 

[2] Liyang Yu, Introduction to the Semantic Web and Semantic Web Services, Capman & Hall/CRC, 2007. 

[3] Mieczyslaw M. Kokar, Matheus et al, Use Cases for Ontologies in Information Fusion, Information Fusion Conf., 2004 . 

[4] Eric Little, Kathryn B. Laskey, Terry Janssen, *Ontologies and* Probabilities: Working Together for Effective Multi-INT Fusion, International Ontology for the Intelligence Community Conf., 2007. 

[5] Brian McBride, *Jena: A Semantic Web Toolkit*, IEEE Internet Computing, vol. 6, no. 6, pp. 55-59, 2002. 

[6] Zhongli Ding, Yun Peng, and Rong Pan, *BayesOWL: Uncertainty* Modelling in Semantic Web Ontologies, book chapter, 2005. 

[7] Pavel Klinov, Pronto: a Non-Monotonic Probabilistic Description Logic Reasoner, European Semantic Web Conf., 2008. 

[8] Laskey, Costa, Janssen, *Probabilistic Ontologies for Knowledge* Fusion, Information Fusion Conf., 2008. 

[9] N. Simou, S. Kollias, FiRE: A Fuzzy Reasoning Engine for Imprecise Knowledge, K-Space PhD Students Workshop, Berlin, Germany, 2007. 

[10] Fernando Bobillo and Umberto Straccia, *fuzzyDL: An Expressive* Fuzzy Description Logic Reasoner, Fuzzy Systems, in: Proceedings of the 17th IEEE International Conf. on Fuzzy Systems (FUZZ-IEEE 
2008), 2008. 

[11] Glenn Shafer; *A Mathematical Theory of Evidence,*
Princeton University Press, 1976. 

[12] Eric Lefevre, Fusion adaptée d'informations conflictuelles dans le cadre de la théorie de l'évidence, thesis presented at the Institut National des Sciences Appliquées of Rouen, 2001. 

[13] Alain Nifle, Modélisation comportementale en fusion de données. 

Application à la détection et l'identification d'objets ou de situations, thesis presented at the Université de Paris-Sud, 1998. 

[14] Miklos Nagy, Maria Vargas-Vera, and Enrico Motta, Uncertain Reasoning for Creating Ontology Mapping on the Semantic Web, International Semantic Web Conf. (ISWC), Korea; November 2007. 

[15] Boutheina Ben Yaghlane and Najoua Laamari, *OWL-CM: OWL* 
Combining Matcher based on Belief Functions Theory, In: 
Proceedings of the 2nd International Workshop on Ontology Matching, 2007. 

[16] Amira Essaid and Boutheina Ben Yaghlane, BeliefOWL: An Evidential Representation in OWL Ontology, pages 77-80, International Semantic Web Conference, International Workshop on Uncertainty Reasoning for the Semantic Web, Washington DC, USA, 
2009. 

[17] Open source Java Dempster-Shafer library developed by Thomas Reineking, http://mac.softpedia.com/get/Development/Java/JavaDempster-Shafer-Library.shtml. 

[18] Horrocks, I., Patel-Schneider, P.F., Boley, H., et al., *SWRL: A* 
semantic web rule language combining OWL and RuleML. W3C 
Member Submission, 21 May 2004. Available at: 
http://www.w3.org/Submission/SWRL/ 
[19] Michael Kifer, *Rule Interchange Format: The Framework*, 
Proceedings of the 2nd International Conference on Web Reasoning and Rule Systems, Karlsruhe, Germany, 2008. 