# Coincidences And The Encounter Problem: A Formal Account Jean-Louis Dessalles (Dessalles@Enst.Fr) Telecom Paristech, 46 Rue Barrault F-75013 Paris, France

## Abstract

Individuals have an intuitive perception of what makes a good coincidence. Though the sensitivity to coincidences has often been presented as resulting from an erroneous assessment of probability, it appears to be a genuine competence, based on non-trivial computations. The model presented here suggests that coincidences occur when subjects perceive complexity drops. Co-occurring events are, together, simpler than if considered separately. This model leads to a possible redefinition of subjective probability.

Keywords: coincidence; complexity; probability; unexpectedness; surprise.

## Coincidences

Suicides are banal events: About thirty people commit suicide every day in a country like France. Yet, a French national newspaper, *Le Figaro*, reported two anonymous suicides in its March 20, 2004 edition, insisting on their similarity: Two late middle aged women who did not know each other walked in elegant dress into the sea and drowned, almost simultaneously early in the morning, just a few kilometers away from one another. The coincidence was so strange that the news was subsequently analyzed on a national radio.

The famous parallel between Abraham Lincoln and John F. Kennedy"s fates leaves no one indifferent, even if one knows that the coincidence should not be regarded as unlikely (Kern & Brow, 2001). Their election to Congress and then as president of the United States, the births of their successors, the births of their assassins occurred on the same years, one century apart. Both successors were named Johnson. Both assassins were themselves assassinated before being tried.

Two Parisian colleagues running into each other in a small village close to Coban, Guatemala, perceive the coincidence as incredible and urge to tell the event to their friends.

Studying why and how human beings are fascinated by coincidences constitutes an important chapter of cognitive science. Coincidence avoidance has definite implications for decision making, especially in science and in court of law. Moreover, people can accurately assess the strength of coincidences (Griffiths & Tenenbaum, 2001; 2007), which means that they are able to capture complex relations between events.

The human sensitivity to coincidences is an embarrassment for most current models of cognition. Some authors consider it as mere marginal malfunction of an otherwise functional general ability to assess the likelihood of events. The malfunction would be due to representativeness bias 
(Kahneman & Tversky, 1972), to erroneous prior knowledge (Bar-Hillel, 1980) or to failure to consider proper alternatives (Diaconis & Mosteller, 1989; Falk, 1989; Tversky & Kohler, 1994). Other authors see in the perception of coincidences a fundamental device for concept learning and theory formation (Griffiths & Tenenbaum, 2007). The aim of the present paper is not to settle the issue, although our model clearly depicts the sensitivity to coincidences as a genuine competence rather than as the result of a malfunction. Our contribution, which builds on recent studies on cognitive complexity, is limited to showing that the perception of coincidences obeys definite, formal laws. This mere fact, if correct, may have some implications for our understanding of human cognition, especially by shedding new light on the notion of subjective probability.

Though coincidences are systematically experienced as improbable by subjects, their relation to probability is notoriously unclear: Among events of same probability, some may appear coincidental and others not (Griffiths & Tenenbaum, 2007). For instance, children"s attention is grabbed when the family car reaches 66666 km on the clock, but they do not care when they read 67426 km. People are stunned when unexpectedly meeting a friend in a remote place, although they are fully unable to quantify the probability of the event.

Recent accounts of the human ability to assess coincidences split into two opposite directions. Some authors would consider that the basic ingredient of coincidences is the probability of the event (Falk, 1989) or of its putative causes (Griffiths & Tenenbaum, 2007), even if they acknowledge the role that descriptive complexity may play (Griffiths & Tenenbaum, 2003). Some other studies have signaled the crucial role of descriptive complexity in cognitive processes (Chater, 1999; Chater & 
Vitányi, 2003) and more particularly in the perception of coincidences (Feldman, 2004). The former group view 
"probability as primary, and the relationship between randomness and complexity as a secondary consequence of a statistical inference" (Griffiths & Tenenbaum, 2003). The present account, in line with the second group of studies, puts descriptive complexity at the core of the cognitive competence underlying the perception of coincidences.

In what follows, we first give a list of problems that cognitive models of coincidences must address. We then define the notion of unexpectedness as complexity drop, before showing that this notion nicely accounts for each of the listed problems, including the "encounter problem". We finally consider the compatibility of the model with traditional probabilistic accounts.