
## What Is To Be Explained

There are required specifications that a cognitive model of coincidence must meet. Let us phrase them using three examples, the double suicide by drowning, the LincolnKennedy parallel and the fortuitous encounter.

- *Analogy*: Each common feature between Lincoln and Kennedy"s lives adds to the coincidence. In the case of the two drowned women, interest would have been even higher if they had had the same first name. If they had been of different ages, interest would have been lower. The repeated 100-year interval in the two-president coincidence is an analogy within the analogy.

- *Association*: Non-analogue features, such as the fact that Kennedy was shot in a car named Lincoln, still add to the coincidence value.

- *Prominence*: Kennedy and Lincoln are among the foremost US presidents. The coincidence would be less interesting if it involved obscure US presidents, or prominent Uruguayan presidents (for non-Uruguayan citizens).

- *Round numbers*: The Lincoln-Kennedy coincidence would be slightly less interesting if it involved an 87-year interval.

- *Closeness*: The short distance between the two suicides is a crucial aspect of the coincidence. In the report, proximity in time (early in the same morning), in space (a few kilometers apart) and in social hierarchy (two upperclass women) was highlighted. Conversely, interest in the coincidence would drop if the distance in any of these dimensions was increased.

- *Remoteness*: The remoteness of the place is a crucial ingredient of fortuitous encounters. While there is no coincidence in encountering a colleague two blocks away from workplace, running into a colleague in an obscure village 9000 km away from home is thrilling. 

- *Egocentricity*: People are much more sensitive to coincidences (*e.g.* having same birth dates) when they are involved (Falk, 1989). The double suicide is much more intriguing for people who live close to the place where the event took place.

- *Causality*: Surprise vanishes when the coincidental events find a common easy causal explanation, for instance if the two suicidal women knew each other and had made a common decision. Conversely, interest is preserved when the available explanatory hypotheses are highly unlikely (Griffiths & Tenenbaum, 2007) as the fact, mentioned on the radio, that the two drowned women may have influenced each other through telepathy.

All these parameters have *systematic* effects on the perception of coincidences. This is an indication that some genuine cognitive competence is at work and that the surprise generated by coincidences is not the mere sideeffect of a general sensitivity to the presence of statistical exceptions. Probabilistic or statistical accounts would fail to account for most of the above properties, though they may suggest local laws in the case of closeness and egocentricity 
(using Poisson distributions), of remoteness (using a diffusion model) and of explanation (using Bayesian networks: Griffiths & Tenenbaum, 2007). A unified account is proposed now.

## Unexpectedness And Descriptive Complexity

The core property of coincidences is that they are unexpected. Unexpectedness has been given various definitions. An obvious one corresponds to Shannon"s definition of information U = log2 1/pi, where piis the a priori probability of the event (Shannon, 1948). Another is U =  pj 2/pi (Weaver, 1948); it accounts for the fact that improbable events are only interesting if they are a contrast to probable alternatives. Various authors have noticed the close relation between description *complexity*, also known as Kolmogorov complexity, and probability (Solomonoff, 1978; 1997; Chater, 1999; Feldman, 2004). The problem with Solomonoff"s definition of probability as p = 2
–C, 
where C is the complexity of the event, is that simpler situations are assigned higher probability, as they are more likely to be generated. In coincidences, the reverse happens: Events are perceived as unlikely when they are "too" simple, for instance simpler than what the "null hypothesis" predicts 
(Feldman, 2004). We propose a similar idea, captured in the following definition of *unexpectedness*.

U(D) = Cw(D) - C(D) (1)
As observed by Tversky and Koehler (1994), "probability judgments are attached not to events but to descriptions of events". The unexpectedness of an event described through D is the difference between its W-complexity, or complexity "in the world" (as it is understood by the subject) and its observational complexity or O-complexity. Both Cw and C
are cognitive: They correspond to minimal cognitive descriptions available to the individual (Chater, 1999). They express the length of minimal "programs" given to two different "machines" that may be dubbed W-machine and Omachine. The W-machine functions according to what the subject sees as the normal behavior of the world (the Wmachine, therefore, depends on the subject"s knowledge). 

The O-machine is unconstrained and may use any observational ability available to the subject. Cw and C are the minimal amounts of instructions, in bits, that must be given as input to these machines to *generate* the event described by D. These definitions are consistent with the original definition of Kolmogorov complexity, except that the ideal Turing machine is replaced by two versions of the human cognitive analysis capabilities.

Consider the coincidence of seeing 66666 on the clock when driving. The W-machine generates this pattern by copying an uninstantiated digit and then by performing five independent instantiations. The W-complexity thus amounts to Cw = C*copy* + 5log2 10 (as the complexity of designating one number chosen among n is log2 n). The O-machine generates the same pattern by copying an instantiated digit: 
C = log2 10 + C*copy*. We thus get: U = 4log2 10 = 13.3 bit.