According to definition (1), merely mentioning "John F. 

Kennedy" creates a negative unexpectedness. The world (as the subject knows it) is supposed to be available to the Wmachine; therefore, the W-complexity of "John F. Kennedy" is zero, as he is believed to have existed. The O-machine requires a non-zero input to determine "John F. Kennedy". A minimal cognitive description may use a list of famous characters ranked by celebrity. The O-complexity would be the logarithm of Kennedy"s rank in that list. Alternatively (especially for people outside the US), a minimal description may go through the mention of the notion of US 
presidency, and then through the determination of John Kennedy among US presidents. O-complexity here is related to cognitive availability (Tversky & Kahneman, 1973) and may be independently assessed by various means including reaction times.

The mere mention of a feature like Kennedy"s age by the time he was killed requires no work from the W-machine, as everyone has an age; but its instantiation to a definite value such as 46 involves some complexity. In the worst case, the W-machine generates that age by copying it from its input. 

However, the W-machine may determine the age by choosing among likely age values for a US president, which leads to a lower complexity.

## Unexpectedness And Coincidences

Let us show now how the notion of unexpectedness can account for the eight specifications previously listed. We need the notion of *computation sequence*, noted with operator *. The sequence D1*D2 means that the W-machine needs to generate D1 before generating D2:
Cw(D1*D2) = Cw(D1) + Cw(D2|D1) (2)
In a coincidence like the double suicide, the two events e1 and e2 are independent for the W-machine: Cw(e2|e1) = 
Cw(e2). We get:
U(e1*e2) > Cw(e1) + Cw(e2) - C(e1) - C(e2|e1) (3)
The inequality comes from the fact that the computation sequence may be suboptimal for the O-machine. We can now review the eight specifications.

Analogy: This formula correctly predicts the importance of a close analogy between the two events, as best analogies make C(e1) + C(e2|e1) minimum (Cornuéjols, 1996). Each new common element, such as the birth date of the assassins in the Lincoln-Kennedy parallel, is needed twice for the Wmachine, but only once for the O-machine, as its contribution to C(e2|e1) is zero. Common elements thus add to the unexpectedness of the situation. An additional prediction is that more complex common elements will be more surprising. Interest would indeed grow if the two drowned women wore a tattoo, but even more so if both had a red fivecentimeter long tattoo on the right shoulder. 

Association: Inequation (3) predicts that any element of e1 that the O-machine can reuse to generate e2 will add to the surprise. Hence the mention that Kennedy was killed in car named Lincoln. The W-machine must generate the make of the car and requires several bits which add to Cw(e2) to distinguish it from other makes; this generation is easier for the O-machine when e1 is given as input, as the name 
"Lincoln" is available for free.

Prominence: Why is it important that Abraham Lincoln and John F. Kennedy be famous? Formula (3) provides an answer. These two persons exist and are unique in the subject"s world; the W-machine has thus no work to do to generate them. For the O-machine, however, their minimal description may go through determining their social role, US president, and then find them in a ranked list of USpresidents. Hence the importance for the coincidence to involve two prominent figures, as their complexity, which amounts to the logarithm of their rank in a list ordered by celebrity, adds to C(e1) and to C(e2|e1). Similarly, a social role such as president of Uruguay, if more complex for the subject, makes the coincidence less surprising, as it adds significantly to C(e1).

Round numbers: The presence of the negative term 
-- C(e2|e1) in (3) explains why the Lincoln-Kennedy story is more interesting as it is than if the repeated time interval had been of 87 years instead of 100. The point is that the cognitive complexity of the program that transforms 1846 into 1946 or 1860 into 1960 is simpler than the program that would transform 1846 into 1933 and 1860 into 1947 (the first program affects only one digit). Alternatively, one can observe that 100, as a number, is simpler than 87. The complexity of an integer n is smaller than log2 n. In the case of round numbers, it is significantly smaller. One million may be concisely defined as 106, or as 1 followed by six copies of 0.

Closeness: The role of closeness in time and space, as in the example of the double suicide, can only be understood if the notion of complexity is extended to continuous quantities. Though Kolmogorov complexity is defined only for discrete structures, the complexity of a place is naturally defined as the most concise set of directions that allows finding it. Locating a surface a 2on a two-dimensional area S
requires no more than log2 (S/a 2) bits. When trying to locate such an area B from a place A, one may use a relative code, in which locations are ranked according to their distance from A. In such a system, the complexity of B amounts to C(B|A) = log2 (d 2/a 2), where d is the distance from A to B. 

This complexity varies as 2log2 d. In expression (3), the W-machine must compute the location of each event independently. The O-machine computes the location of one event, and then may use a relative coding. Hence the crucial importance of the two events being close to each other, as C(e2|e1) involves a term 2log2 d. The same prediction holds for the time dimension: Surprisingness decreases as log2 t where t is the time interval between the two events.