Proximity effects do not require the presence of two events. On July 22, 2003, a minor blaze on the upper floor of the Eiffel Tower was reported in French national news media. This phenomenon is explained by formula (1). The W-machine must generate the location of the blaze. If fires occur with a spatial density D, then localizing one of them demands log2 1/(a 2D) bits, as 1/D represents the area of occurrence of one such event on average. The O-machine has first to specify the location of the Eiffel Tower, but this requires minimum complexity as the place is prominent (it is the top most popular monument in France). Then the Omachine gets the location of the blaze for free. The coincidence effect is predicted to decrease as the logarithm of the spatial density of the event and proportionally to the complexity of the monument. No wonder that events happening on prominent places are preferentially reported in the news (Warren, 1934).

Remoteness: Fortuitous encounters seem to be an exception to the rule of closeness, as the interest of the coincidence grows this time with the remoteness of the place! A proper application of (3), however, restores the prediction.

First, let us observe that the encounter problem is spectacular, as it provides the best evidence that the human mind is sensitive to description complexity. In this kind of coincidence, interest grows with the *complexity of the place* and with the *simplicity of the encountered person*. The complexity of the place l is the relevant factor, not the distance: 
a big distant airport may be less complex than the backyard of an obscure building of a lost suburb a few kilometers away. The simplicity of the encountered person P is the relevant factor, not her closeness. Running into a celebrity may be as unexpected as running into a close colleague.

These phenomenon is correctly predicted by the fact that unexpectedness varies as C(l) - C(P), as we show now.

Let us compute1the unexpectedness of the sequence ego*P*l(ego)*l(P). Here, l(ego) and l(P) designate the presence of self and of P at location l. For the W-machine, Cw(P) = 0 as P is supposed to exist. In the "world", P"s and ego's presence at l are independent: Cw*(l(P)|l*(ego)) = 
Cw*(l(P*)). If ego and P play symmetrical roles, the Wmachine requires Cw(*ego*P*l(ego)*l(P*)) = 2 Cw*(l(ego*)) to generate the encounter situation. The term Cw(l(ego)) 
corresponds to the minimum size of a set of directions to reach l and amounts to C(l) in most cases (except if l is materially difficult to reach). On the other hand, for the Omachine, C(l(P)|*l(ego*)) is zero. The O-machine demands C(P) to determine P and C(l(ego)) to bring ego to l. Again, we suppose that C(l(ego)) = C(l). We get, as announced:
U(ego*P*l(ego)*l(P)) > C(l) - C(P) (4)
An alternative computation goes over the sequence ego*l(ego)*l(P)*P. This time, P is first determined by her position l(P) = l(ego). Now Cw*(l(P)|l*(ego)) is zero, but not Cw(P|l(P)). To instantiate P, the W-machine has to distinguish among all individuals that may happen to be in l. One procedure to do so consists in checking local people first, by delimiting an area of radius R around l and considering all people living within it. Then R is increased until the actual P is reached. In this computation, l and P"s home play symmetrical roles, so that Cw(P|l(P)) = C(l) + c
(again, l is supposed to be as complex for P as for ego). The constant c depends on the spatial density of people. The resulting unexpectedness C(l) + c - C(P) is similar to what we obtained in (4). Note that this second computation still holds when the encounter occurs in the vicinity of ego"s home. In this case, Cw*(l(ego*)) and C(*l(ego*)) are negligible, but Cw(l(P)) is close to C(h(P)) (the complexity of P"s home) and the unexpectedness amounts to *C(h(P*)) + c - C(P). It is indeed quite a coincidence to meet a celebrity in front of one"s home.

Egocentricity: In the case of fortuitous encounters as for 
happening to have the same birthday, the coincidence is less impressive if it involves another person Q instead of ego
(Falk, 1989). This effect is well predicted by formula (1): The burden of determining Q adds to the O-complexity (but not to the W-complexity) and unexpectedness is diminished 
by the amount C(Q). This accounts for the fact that firsthand stories are always preferred (Coates, 2003), since they 
are systematically more unexpected. To show this, we can 
derive the following inequation from (2):
U(D1*D2) > U(D1) + U(D2|D1) (5)
A recursive application of (5) gives: *U(Q*e*1*e2) = - C(Q) 
+ U(e1|Q) + U(e2*|Q&e*1). We may consider that U(e2|Q&e1) *= U(e*2|e1), as the most concise description of e2 for the O-machine only uses e1, whereas the W-machine uses neither e1 nor Q.
U(Q*e1*e2) > - C(Q) + U(e1|Q) + U(e2|e1) (6) 
If $Q$ is replaced by $ego$, we get:  . 
This explains why coincidences involving ego are more 
intriguing, as unexpectedness is larger in (7) than in (6). Importantly, this "egocentric touch" (Falk, 1989) is obtained without any extensional reasoning. The present account considers neither alternatives nor "the size of the set to 
which one implicitly relates" (Falk, 1989). 
Equation (7) also explains why a coincidence like the 
double suicide is more surprising to local people. The value 
of U(e1|ego) may be significant, as it would be for a single 
suicide happening in the vicinity, whereas it may be negative for people living farther away.
$$U(e g o^{*}e_{1}{}^{*}e_{2})\geq U(e_{1}|e g o)+U(e_{2}|e_{1})$$
$\left(-1,\frac{1}{2}\right)$ $\left(-1,\frac{1}{2}\right)$ $\left(-1,\frac{1}{2}\right)$ $\left(-1,\frac{1}{2}\right)$
$$\mathbf{r}=\mathbf{r}$$
$\mathbf{a}\cdot\mathbf{a}=\mathbf{a}\cdot\mathbf{a}$. 
$\eqref{eq:walpha}$. 
Causality: Griffith and Tennenbaum (2007) developed a probabilistic (Bayesian) account of the reason why coinci-