# Rooting Opinions In The Minds: A Cognitive Model And A Formal Account Of Opinions And Their Dynamics Francesca Giardini 1 , Walter Quattrociocchi 2And Rosaria Conte 3

arXiv:1106.4218v1 [cs.AI] 21 Jun 2011 Abstract. The study of opinions, their formation and change, is one of the defining topics addressed by social psychology, but in recent years other disciplines, like computer science and complexity, have tried to deal with this issue. Despite the flourishing of different models and theories in both fields, several key questions still remain unanswered. The understanding of how opinions change and the way they are affected by social influence are challenging issues requiring a thorough analysis of opinion per se but also of the way in which they travel between agents' minds and are modulated by these exchanges. To account for the two-faceted nature of opinions, which are mental entities undergoing complex social processes, we outline a preliminary model in which a cognitive theory of opinions is put forward and it is paired with a formal description of them and of their spreading among minds. Furthermore, investigating social influence also implies the necessity to account for the way in which people change their minds, as a consequence of interacting with other people, and the need to explain the higher or lower persistence of such changes.

## 1 Introduction

The studies about opinions, persuasion and social influence are foundational and pressing issues in social psychology; however, within this discipline, the dynamics of opinions at the level of population has been underestimated. There are also other disciplines that have shown a great interest regarding such an issue, ranging from political science ([17]) passing through socio-physics ([7]) up to complexity science ([18]). Understanding opinions, describing how they are generated and revised, and how fare opinions travel over the social space both as a consequence of social influence and as one of the main means through which social influence unfolds, is crucial for grasping a deeper understanding of human social cognition and behaviors.

Investigating opinions requires to take into account two levels of explanation: the individual and the social level. Social psychology has been mainly interested in explaining this first level, trying to describe the complex interplay of affective, cognitive and behavioral aspects that make opinions emerge. On the other hand, scholars from computer science and physics have tried to explain how different opinions can coexist or how they are modified through social interactions, treating opinions as objects that are exchanged and revised according to certain mechanisms that are quite far from the reality of cognitive and social processes. In both cases there is a reductionist fallacy that works in apparently different ways but it affects both these approaches, leading them to treat opinions either as a set of unrelated specific elements or as a unidimensional object that has nothing in common with a cognitive representation.

We claim that opinions are highly dynamical representations resulting from the interplay of different mental representations and affected by the mental states of other individuals in the same network.

Aim of this work is to provide an interdisciplinary account to describe how social influence leads to opinion formation, evolution and change. Moving from a characterization of opinions as mental representations with specific features, we will try to model how opinions are generated within the agents' minds (micro-level) and how they spread within a network of agents (macro-level). When explaining the emergence of macro-social phenomena we need to know what happens at the micro-level, i.e. what drives human actions and decisions in order to understand how individuals' representations and behaviors can give rise to socially complex phenomena and how those affect agents' actions. Without explaining how opinions are formed and manipulated within the individuals' minds, it is very difficult to account for the way in which they change as an effect of social influence. Our aim is to understand whether and how heterogeneous agents, endowed with different beliefs and goals, may come to share a given viewpoint and what consequences this sharing has on agents' behaviors. We are interested in providing answers, at least partially, to the following questions: What is an opinion? What mechanisms lead people to change their opinions? How can individuals resist to changes? What are the mechanisms of influence acting within and between individual minds? How does social impact affect agents' elaboration of new or contrasting information?

As opinion is still a debated concept within several disciplines, either its conceptualization or formalization are hard tasks. In particular, the actual instruments -e.g. metrics, formalisms does not allow for a tight definition accounting for a) the relationships between opinions and other epistemic representations and b) their dynamics both at social and individual level. In this paper we approach a preliminary formal definition of opinions by means of *Time Varying Graphs* [8]- e.g. a new formalism aimed at characterizing dynamically evolving systems as shown in [23, 22].

In section 2, a brief review of the state of the art is provided to introduce the main theories of opinions developed in the field of social psychology and to discuss more recent advances in opinion dynamics. Section 3 is devoted to the description of our model, in which a definition of opinions as specific mental representations and cognitively founded hypotheses about their diffusion and change will be put forward. In section 4 a preliminary formal account of how opinions are generated and how they can change is provided. In section 5 some conclusions are drawn and future directions are suggested.