
## 2 State Of The Art

Social psychologists have devoted much attention to the study of opinions' formation and spreading, but a comprehensive and definite model allowing for an operational and generative account is still missing. Providing a comprehensive review of social psychology literature is beyond the scope of this work, but in this section we will discuss some of the main theories in order to underline how partial is the picture of opinions emerging from these studies.

In general, opinions are treated as synonyms for different mental objects, as beliefs [20], or more frequently, attitudes. Opinions are often conceptualized as attitudes [19], [15], [21] or they are used as interchangeable terms that have in common the fact of being affected by social influence and persuasion [25]. Allport [3] recognizes the difference between attitudes and opinions but he nonetheless considers the measurement of opinions as one way of identifying the strength and value of personal attitudes. An alternative view contrasts the affective content of attitudes with the more cognitive quality of opinions that involve some kind of conscious judgements
[12]. Crespi [9] considers individual opinions as "judgemental outcomes of an individual's transactions with the surrounding world"
(p.19), emphasizing the interplay between what he calls an attitudinal system and the external world characterized by the presence of other agents and different subjective perceptions. Opinions are the outcomes of a judging process but this does not mean that they are necessarily rational or reasoned, although Crespi recognizes that they need to be consistent with the individual's beliefs, values and affective states. As other authors already pointed out [1], many models of opinion and social influence do not provide careful definitions of what an opinion is and how it is affected by social influence. This happens to be true also for theories of persuasion, like the social impact theory [16], a static theory of how social processes operate at the level of the individual at a given point in time. Part of this theory has been developed usign computational modeling by Nowak, Szamrej and Latan [2]. In their model, individuals change their attitudes as a consequence of other individuals' influence. In parallel with the idea that social influence is proportional to a multiplicative function of the strength, immediacy, and number of sources in a social force field
[16], [13] suggest that each attitude within a cognitive structure is jointly determined by the strength, immediacy, and number of linked attitudes as individuals seek harmony, balance, or consistency among them. Although very interesting, this account fails to distinguish between attitudes and beliefs and does not explain how inconsistencies can be resolved. The effect of communication on opinion formation has been addressed by different disciplines from within the social and the computational sciences, as well as complex systems science (for a review on attitude change models, see [1]). One of the first works on this topic has focused on polarization, i.e. the concentration of opinions by means of interaction, as one main effect of the "social influence" [11], whereas the Social Impact Theory' [2] proposes a more dynamic account, in which the amount of influence depends on the distance, number, and strength (i.e., persuasiveness) of influence sources. As stated in ([7]), an important variable, poorly controlled in current studies, is structure topology. Interactions are invariably assumed as either all-to-all or based on a spatial regular location (lattice), while more realistic scenarios are ignored.

Turning our attention to complex systems science, one of the most popular model applied to the aggregation of opinions is the bounded confidence model, presented in [10]. Much like previous studies, in this work agents exchanging information are modeled as likely to adjust their opinions only if the preceding and the received information are close enough to each other. Such aspect is modeled by introducing a real number ǫ, which stands for tolerance or uncertainty ([7])
such that an agent with opinion x interacts only with agents whose opinions is in the interval ]x − **ǫ, x** + ǫ[.

The model we present in this paper extends the bounded confidence model by providing a cognitively plausible definition of opinion as mental representations and identifying their constitutive elements and their relationships.

## 2.1 Main Advances

This work aims at outlining a non-reductionist cognitive model of opinions and their dynamics. Differently from the models reviewed above, we first provide a definition of opinions as mental representations presenting specific features that make their revision and updating more or less easy and enduring. Moreover, grounding opinions in the minds allow us to take into account not only direct processes of revision triggered by the comparison with others' different opinions, i.e. social influence, but also revisions based upon changing in other mental representations supporting that opinion.

The computational model introduced in this paper is intended to provide a preliminary unifying framework to define opinions and to characterize their dynamics in an easy but non-reductionist approach.

Opinions in several models of opinion dynamics are considered to change according to social influence, we try to outline what is social influence and the way the social network structure affects the agents' opinions.

## 3 A Cognitive Theory Of Opinions

Opinions can be described as configurations of an individual's beliefs, values and feelings that can be conditionally activated. This means that, for instance, starting from my feeling of aversion toward mathematics and as a consequence of having met a rude friend of friends who happened to teach math at school, when asked about my opinion on the time kids should spend in studying mathematics, I can form or, better, activate an opinion according to which the less time they spend the better it is. Opinions stem from the conditional activation of different kinds of mental representations, that can have a propositional content or, as in the case of attitudes and feelings, they can be more evaluative. However, there is a specific feature that distinguishes an opinion from other kinds of mental objects. An opinion is an epistemic representation, thus it is a belief in which the truth-value is deemed to be uncertain. Opinions refer to objects of the external world that can not be told to be either true or false.

This impossibility to say whether the content of a representation is true or false is what makes a mental representation an opinion, as opposed to a piece of knowledge, for instance. This basic feature can be paired with the presence of an attitude, i.e. an evaluative component that specifies whether the individual likes or dislikes the topic.

In general, attitudes are present when the topic is somehow involving for the subject, so he is positively or negatively inclined toward it.

When this is not the case, we have "factual opinions", like in the following example. If someone is required to say when Mozart died, he can know the correct answer or not, but this is not a moot point.

On the contrary, the causes of Mozart's death are debatable because without knowing where he was buried it is impossible to analyze the bones and to ascertain what killed him. This means that we know that Mozart died in 1791 but there are contrasting opinions about the causes of his death, and, even if there exist one true opinion, none can tell which is the truth. On the other hand, when opinions involve