
## 4.1.4 Graph-Centric Evolution

From a global standpoint, the evolution of the system can be derived by a sequence of (static) graphs SG = G1, G2.. where every Gi corresponds to a static *snapshot* of G such that e ∈ EGi ⇐⇒
ρ[ti,ti+1)(e) = 1, with two possible meanings for the tis: either the sequence of tis is a discretization of time (for example ti = i);
or it corresponds to the set of particular dates when topological events occur in the graph, in which case this sequence is equal to sort(∪{ST (e) : e ∈ E}). In the latter case, the sequence is called characteristic dates of G, and noted ST (G).

## 4.2 Modeling Epistemic Representations

An *opinion* is an epistemic representation of a state of the world with respect to a given object p. It is defined on a three dimensional space defined by: a) the *objective truth value* To, a *subjective truth value*, namely Ts and a *degree of confidence* dc with respect to the object p.

More formally we can state that:
Definition 1 *an epistemic representation of a state of the world* m ∈ M *is a quadruplet* p, To, Ts, dc defined by a preposition p related to a given object O, and two variable To and Ts defined on R*. The* dc ∈
R *respectively quantifying the "real" truth value of an information,*
namely the objective truth value, the perceived truth values, and the degree of confidence, with respect to the preposition p.

By varying the dimensions of the domain of To and Ts, we can define a taxonomy of the epistemic representation of the world that can be summarised as follows:
Definition 2 *An epistemic representation* mk = {p, To, Ts, dc} is knowledge *when* To = Ts.

Definition 3 *An epistemic representation* mb = {p, To, Ts, dc} *is a* belief *when* 0 < To < 1 ∧ 0 ≤ Ts ≤ 1 . Definition 4 *An epistemic representation* mo = {p, To, Ts, dc} is an **opinion** *when* 0 ≤ To < 1 ∧ 0 ≤ Ts ≤ 1.

## 4.3 Opinions And Individuals

We can define an epistemic representation graph as a network of epistemic representation immerged in a dynamic network in a given time interval and the links state the correlation among them. Let us consider a set V of mental representation (or nodes), interacting with one another over time. Each *relation* among the mental representation can be formalized by a quadruplet c = {u, v, t1, t2}, where u and v are the involved mental representations (either beliefs, or knowledge or an opinion), t1 is the time at which the correlation occurs, and t2 the time at which the relation terminates. A given pair of nodes can naturally be subject to several such interactions over time (and for generality, we allow these interactions to overlap). Given a time interval T = [ta, tb) ⊆ T (where ta and tb may be either two dates, or one date and one infinity, or both infinities), the set C(T )
(or simply C) of all interactions occurring during that time interval defines a set of intermittently-available edges E(T ) ⊆ V × V , such that:

$$\begin{array}{l}{{\forall u,v\in V,(u,v)\in E(T)}}\\ {{{}_{2})\in C(T)\ :\ t_{1}\leq t^{\prime}<t_{2}}}\end{array}$$
⇐⇒ ∃t
′ ∈ [ta, tb),(u, v, t1, t2) ∈ C(T ) : t1 ≤ t
′ < t2(1)
that is, an edge (**u, v**) exists iff at least one interaction between u and v occurs, or terminates, between ta and tb. The intermittent availability of an edge e = (**u, v**) ∈ E(T ) is described by the *presence* function ρ : E(T ) **× T → {**0, 1} such that ∀t ∈ T , e ∈ E(T ):
ρ(**e, t**) = 1 ⇐⇒ ∃(u, v, t1, t2) ∈ C : t1 ≤ **t < t**2 (2)
The triplet G = (**V, E, ρ**) is called an epistemic representation graph, and the temporal domain T = [ta, tb) of the function ρ, is the *lifetime* of G. We denote by G[t,t′)the *mental representation subgraph* of G covering the period [ta, tb) ∩ [**t, t**′)
Hence, a sequence of couples J = {(e1, t1),(e2, t2)**, ...**}, with ei ∈ E and ti ∈ T for all i, is called a *journey* in G iff {e1, e2**, ...**} is a walk in G and for all i, ρ(ei, ti) = 1 and ti+1 ≥ ti. Journeys can be thought of as *paths over time* from a source node to a destination node (if the journey is finite).

Let us denote by J
∗

G the set of all possible journeys in an epistemic representation system G. We will say that G *admits* a journey from a node u to a node v, and note ∃J(u,v) ∈ J ∗
G , if there exists at least one possible journey from u to v in G.

## 4.4 Opinion Dynamics And Society

One of the most famous formalisms aimed at describing the process of persuasion is the "Bounded Confidence Model" (BCM) where agents exchanging information are modeled as likely to adjust their opinions only if the preceding and the received information are close enough to each other. Such an aspect is modeled by introducing a real number ǫ , which stands for tolerance or uncertainty such that an agent with opinion x interacts only with agents whose opinions is in the interval ]x ǫ , x + ǫ [. Neverthless the wide, massive and crossdisciplinary use of the BCM ([18, 14]) ranging from "viral marketing" to to the Italians' opinions distortion played by controlled mass media ([24, 4, 5, 14]). Such a model does not provide an explanation of the phenomena yielding to the tolerance value, it is just assumed as a static value.

In this work we will outline which are the factors affecting the acceptance or the refuse of one another opinion. In particular, how can we formalize comparison of two or more opinions? Recalling that a mental representation is a preposition with the truth value defined by two variable To, Ts ∈ R and dc ∈ R respectively quantifying the "real" and the perceived truth value and the degree of confidence with respect to a given object or proposition. And considering that such mental representations are modeled as set of time connected entities of the form G = (**V, E, ρ**) we can now provide some definitions aimed at describing the process of persuasion.

Assuming that an epistemic representation system, which is by nature adaptive, when facing with external events, reacts to the stimulus by activating only a subset of its components. For instance, consider the example where an agent x is questioned by an agent y about his opinion on a given target.

What does happen in the x's mental representation system? How can we quantify x's attitudes to change or not is opinions regarding a given matter of fact?

According to our model the epistemic representation system of x, as reaction to the external stimulus posed by the y's question, will perform **journey** within the elements that in its mind are related with the target of the question and on this base will be able to compare its opinion with the one owned by y.

Definition 5 (relational-)connected component induced by an external event in Gx *is defined as a set of nodes* V
′ ⊆ V such that