Figure 4 and Figure 5 show several important things. First, while a change in training-set size shifts the performance curves, the relative rank of each point on each performance curve remains roughly the same. Thus, while the class distribution that yields the best performance occasionally varies with training-set size, these variations are relatively rare and when they occur, they are small. For example, Figure 5 (and the supporting details in Appendix B) indicates that for the adult data set, the class distribution that yields the best AUC typically contains 80% minorityclass examples, although there is occasionally a small deviation (with 1/8 the training data 70% 
minority-class examples does best). This gives support to the notion that there may be a "best" marginal class distribution for a learning task and suggests that a progressive sampling algorithm may be useful in locating the class distribution that yields the best, or nearly best, classifier performance. The results also indicate that, for any fixed class distribution, increasing the size of the training set always leads to improved classifier performance. Also note that the performance curves tend to "flatten out" as the size of the data set grows, indicating that the choice of class distribution may become less important as the training-set size grows. Nonetheless, even when all of the available training data are used, the choice of class distribution does make a difference. This is significant because if a plateau had been reached (i.e., learning had stopped), then it would be possible to reduce the size of the training set without degrading classifier performance. In that case it would not be necessary to select the class distribution of the training data carefully. 

The results in Figure 4 and Figure 5 also show that by carefully selecting the class distribution, one can sometimes achieve improved performance while using fewer training examples. To see this, consider the dashed horizontal line in Figure 4, which intersects the curve associated with ¾ of the training data at its lowest error rate, when the class distribution includes 10% minority-class examples. When this horizontal line is below the curve associated with all available training data, then the training set with ¾ of the data outperforms the full training set. In this case we see that ¾ of the training data with a 10% class distribution outperforms the natural class distribution using all of the available training data. The two horizontal lines in Figure 5 highlight just some of the cases where one can achieve improved AUC using fewer training data (because larger AUC values indicate improved performance, compare the horizontal lines with the curves that lie above them). For example, Figure 5 shows that the training set with a class distribution that contains 80% minority-class examples and 1/128th of the total training data outperforms a training set with twice the training data when its class distribution contains less than or equal to 40% minority-class examples (and outperforms a training set with four times the data if its class distribution contains less than or equal to 10% minority-class examples). The results in Appendix B show that all of the trends noted for the adult data set hold for the other data sets and that one can often achieve improved performance using less training data. 

## 7.2 A Budget-Sensitive Progressive Sampling Algorithm For Selecting Training Data

As discussed above, the size of the training set sometimes must be limited due to costs associated with procuring usable training examples. For simplicity, assume that there is a budget n, which permits one to procure exactly n training examples. Further assume that the number of training examples that potentially can be procured is sufficiently large so that a training set of size n can be formed with any desired marginal class distribution. We would like a sampling strategy that selects x minority-class examples and y majority-class examples, where *x + y = n*, such that the 