the class distributions within the beam and then to induce and to evaluate the classifiers. At a minimum this procedure will evaluate the class distributions at the endpoints and at the midpoint of the beam; however, this procedure may be implemented to evaluate additional class distributions within the beam. The procedure will set the variable *best* to the class distribution that performs best. If the best performance is achieved by several class distributions, then a resolution procedure is needed. For example, the class distribution for which the surrounding class distributions perform best may be chosen; if this still does not yield a unique value, then the bestperforming class distribution closest to the center of the beam may be chosen. In any event, for the last iteration, only one class distribution is evaluated—the previous best. To ensure budgetefficiency, only one class distribution can be evaluated in the final iteration. 

This algorithm is guaranteed to request only examples that are subsequently used in the final training set, which will have the heuristically determined class distribution. This guarantee can be verified inductively. First, the base case. The calculation for K in line 2 ensures that the initial training set will contain *cmin* - n training examples. Since we assume that the final training set will have at least *cmin* minority-class examples and *cmin* majority-class examples, all examples used to form the initial training set are guaranteed to be included in the final training set. 

Note that *cmin* may be set arbitrarily small—the smaller *cmin* the larger K and the smaller the size of the initial training set. 

The inductive step is based on the observation that because the radius of the beam in line 11 is set so that the beam spans at most a factor of µ, all examples requested in each iteration are guaranteed to be used in the final training set. To see this, we will work backward from the final iteration, rather than working forward as is the case in most inductive proofs. Assume that the result of the algorithm is that the fraction of minority-class examples in the final training set is p, so that there are p - n minority-class examples in the final training set. This means that p was the best distribution from the previous iteration. Since p must fall somewhere within the beam for the previous iteration and the beam must span a factor µ, we can say the following: the fraction of minority-class examples in the previous iteration could range from p/µ (if p was at the top of the previous beam) to µ - p (if p was at the bottom of the previous beam). Since the previous iteration contains n/µ examples, due to the geometric sampling scheme, then the previous iteration has at most (µ - p) - n/µ, or *p - n*, minority-class examples. Thus, in all possible cases all minority-class examples from the previous iteration can be used in the final interaction. This argument applies similarly to the majority-class examples and can be extended backwards to previous iterations.6 Thus, because of the bound on the initial training-set size and the restriction on the width of the beam not to exceed the geometric factor µ, the algorithm guarantees that all examples requested during the execution of the algorithm will be used in the final training set. 

A complete, detailed, iteration-by-iteration example describing the sampling algorithm as it is applied to the phone data set is provided in Appendix C, Table C1. In that example error rate is used to evaluate classifier performance. The description specifies the class distributions that are evaluated during the execution of the algorithm. This "trajectory" is graphically depicted in Figure 6, narrowing in on the final class distribution. At each iteration, the algorithm considers the "beam" of class distributions bounded by the two curves. 