In summary, the sampling algorithm introduced in this section leads to near-optimal resultsresults that outperform the straw-man strategy of using the natural distribution to minimize error rate and the balanced distribution to maximize AUC. Based on these results, the budget-sensitive progressive sampling algorithm is attractive—it incurs the minimum possible cost in terms of procuring examples while permitting the class distribution for training to be selected using some intelligence. 

## 8. Related Work

Several researchers have considered the question of what class distribution to use for a fixed training-set size, and/or, more generally, how class distribution affects classifier performance. 

Both Catlett (1991) and Chan & Stolfo (1998) study the relationship between (marginal) training class distribution and classifier performance when the training-set size is held fixed, but focus most of their attention on other issues. These studies also analyze only a few data sets, which makes it impossible to draw general conclusions about the relationship between class distribution and classifier performance. Nonetheless, based on the results for three data sets, Chan & Stolfo 
(1998) show that when accuracy is the performance metric, a training set that uses the natural class distribution yields the best results. These results agree partially with our results—although we show that the natural distribution does not always maximize accuracy, we show that the optimal distribution generally is close to the natural distribution. Chan & Stolfo also show that when actual costs are factored in (i.e., the cost of a false positive is not the same as a false negative), the natural distribution does not perform best; rather a training distribution closer to a balanced distribution performs best. They also observe, as we did, that by increasing the percentage of minority-class examples in the training set, the induced classifier performs better at classifying minority examples. It is important to note, however, that neither Chan & Stolfo nor Catlett adjusted the induced classifiers to compensate for changes made to the class distribution of the training set. This means that their results are biased in favor of the natural distribution (when measuring classification accuracy) and that they could improve the classification performance of minority class examples simply by changing (implicitly) the decision threshold. As the results in Appendix A show, compensating for the changed class distribution can affect the performance of a classifier significantly. 

Several researchers have looked at the general question of how to reduce the need for labeled training data by selecting the data intelligently, but without explicitly considering the class distribution. For example, Cohn et al. (1994) and Lewis and Catlett (1994) use "active learning" to add examples to the training set for which the classifier is least certain about the classification. Saar-Tsechansky and Provost (2001, 2003) provide an overview of such methods and also extend them to cover AUC and other non-accuracy based performance metrics. The setting where these methods are applicable is different from the setting we consider. In particular, these methods assume either that arbitrary examples can be labeled or that the descriptions of a pool of unlabeled examples are available and the critical cost is associated with labeling them (so the algorithms select the examples intelligently rather than randomly). In our typical setting, the cost is in procuring the descriptions of the examples—the labels are known beforehand. 

There also has been some prior work on progressive sampling strategies. John and Langley 
(1996) show how one can use the extrapolation of learning curves to determine when classifier performance using a subset of available training data comes close to the performance that would be achieved by using the full data set. Provost et al. (1999) suggest using a geometric sampling 