The research in this article could properly be viewed as research into under-sampling and its effect on classifier performance. However, given this perspective, our research performs undersampling in order to reduce the training-set size, whereas in the research relating to skewed data sets the primary motivation is to improve classifier performance. For example, Kubat and Matwin (1997) motivate the use of under-sampling to handle skewed data sets by saying that "adding examples of the majority class to the training set can have a detrimental effect on the learner's behavior: noisy or otherwise unreliable examples from the majority class can overwhelm the minority class" (p. 179). A consequence of these different motivations is that in our experiments we under-sample the minority and/or majority classes, while in the research concerned with learning from skewed distributions it is only the majority class that is under-sampled. 

 The use of under-sampling for reducing the training-set size (and thereby reducing cost) may be the more practically useful perspective. Reducing the class imbalance in the training set effectively causes the learner to impose a greater cost for misclassifying minority-class examples 
(Breiman et al., 1984). Thus, when the cost of acquiring and learning from the data is not an issue, cost-sensitive or probabilistic learning methods are a more direct and arguably more appropriate way of dealing with class imbalance, because they do not have the problems, noted earlier, that are associated with under-sampling and over-sampling. Such approaches have been shown to outperform under-sampling and over-sampling (Japkowicz & Stephen, 2002). To quote Drummond and Holte (2000) "all of the data available can be used to produce the tree, thus throwing away no information, and learning speed is not degraded due to duplicate instances" (p. 

239). 

## 9. Limitations And Future Research

One limitation with the research described in this article is that because all results are based on the use of a decision-tree learner, our conclusions may hold only for this class of learners. However, there are reasons to believe that our conclusions will hold for other learners as well. 

Namely, since the role that class distribution plays in learning—and the reasons, discussed in Section 5.2, for why a classifier will perform worse on the minority class—are not specific to decision-tree learners, one would expect other learners to behave similarly. One class of learners that may especially warrant further attention, however, are those learners that do not form disjunctive concepts. These learners will not suffer in the same way from the "problem of small disjuncts," which our results indicate is partially responsible for minority-class predictions having a higher error rate than majority-class predictions.8 Thus, it would be informative to extend this study to include other classes of learners, to determine which results indeed generalize. 

The program for inducing decision trees used throughout this article, C4.5, only considers the class distribution of the training data when generating the decision tree. The differences between the class distribution of the training data and the test data are accounted for in a post-processing step by re-computing the probability estimates at the leaves and using these estimates to re-label the tree. If the induction program had knowledge of the target (i.e., test) distribution during the tree-building process, then a different decision tree might be constructed. However, research indicates that this is not a serious limitation. In particular, Drummond and Holte (2000) showed that there are splitting criteria that are completely insensitive to the class distribution and that 