these splitting criteria perform as well or better than methods that factor in the class distribution. 

They further showed that C4.5's splitting criterion is relatively insensitive to the class distribution—and therefore to changes in class distribution. We employed C4.5 without pruning in our study because pruning is sensitive to class distribution and C4.5's pruning strategy does not take the changes made to the class distribution of the training data into account. To justify this choice we showed that C4.5 without pruning performs competitively with C4.5 with pruning (Sections 6.2 and 6.3). Moreover, other research (Bradford et al., 1998) indicates that classifier performance does not generally improve when pruning takes class distribution and costs into account. Nevertheless it would be worthwhile to see just how a "cost/distribution-sensitive" pruning strategy would affect our results. We know of no published pruning method that attempts to maximize AUC. 

In this article we introduced a budget-sensitive algorithm for selecting training data when it is costly to obtain usable training examples. It would be interesting to consider the case where it is more costly to procure examples belonging to one class than to another. 

## 10. Conclusion

In this article we analyze, for a fixed training-set size, the relationship between the class distribution of training data and classifier performance with respect to accuracy and AUC. This analysis is useful for applications where data procurement is costly and data can be procured independently by class, or where the costs associated with learning from the training data are sufficient to require that the size of the training set be reduced. Our results indicate that when accuracy is the performance measure, the best class distribution for learning tends to be near the natural class distribution, and when AUC is the performance measure, the best class distribution for learning tends to be near the balanced class distribution. These general guidelines are just thatguidelines—and for a particular data set a different class distribution may lead to substantial improvements in classifier performance. Nonetheless, if no additional information is provided and a class distribution must be chosen without any experimentation, our results show that for accuracy and for AUC maximization, the natural distribution and a balanced distribution (respectively) are reasonable default training distributions. 

If it is possible to interleave data procurement and learning, we show that a budget-sensitive progressive sampling strategy can improve upon the default strategy of using the natural distribution to maximize accuracy and a balanced distribution to maximize the area under the ROC 
curve—in our experiments the budget-sensitive sampling strategy never did worse. Furthermore, in our experiments the sampling strategy performs nearly as well as the strategy that evaluates many different class distributions and chooses the best-performing one (which is optimal in terms of classification performance but inefficient in terms of the number of examples required). 

The results presented in this article also indicate that for many data sets the class distribution that yields the best-performing classifiers remains relatively constant for different training-set sizes, supporting the notion that there often is a "best" marginal class distribution. These results further show that as the amount of training data increases the differences in performance for different class distributions lessen (for both error rate and AUC), indicating that as more data becomes available, the choice of marginal class distribution becomes less and less importantespecially in the neighborhood of the optimal distribution. 

This article also provides a more comprehensive understanding of how class distribution affects learning and suggests answers to some fundamental questions, such as why classifiers almost always perform worse at classifying minority-class examples. A method for adjusting a 