limited to include approximately 650,000 training examples, which were generated from approximately 600 million call-detail records. Because huge transaction-oriented databases are now routinely being used for learning, we expect that the number of training examples will also need to be limited in many of these cases. 

The remainder of this article is organized as follows. Section 2 introduces terminology that will be used throughout this article. Section 3 describes how to adjust a classifier to compensate for changes made to the class distribution of the training set, so that the generated classifier is not improperly biased. The experimental methodology and the twenty-six benchmark data sets analyzed in this article are described in Section 4. In Section 5 the performance of the classifiers induced from the twenty-six naturally unbalanced data sets is analyzed, in order to show how class distribution affects the behavior and performance of the induced classifiers. Section 6, which includes our main empirical results, analyzes how varying the class distribution of the training data affects classifier performance. Section 7 then describes a progressive sampling algorithm for selecting training examples, such that the resulting class distribution yields classifiers that perform well. Related research is described in Section 8 and limitations of our research and future research directions are discussed in Section 9. The main lessons learned from our research are summarized in Section 10. 

## 2. Background And Notation

Let x be an instance drawn from some fixed distribution D. Every instance x is mapped (perhaps probabilistically) to a class C ∈ {p, n} by the function c, where c represents the true, but unknown, classification function.1 Let ρ be the marginal probability of membership of x in the positive class and 1 - ρ the marginal probability of membership in the negative class. These marginal probabilities sometimes are referred to as the "class priors" or the "base rate." 
A classifier t is a mapping from instances x to classes {p, n} and is an approximation of c. 

For notational convenience, let t(x) ∈ {P, N} so that it is always clear whether a class value is an actual (lower case) or predicted (upper case) value. The expected accuracy of a classifier t, αt
, is defined as αt = Pr(t(x) = c(x)), or, equivalently as: 

$$|\operatorname{c}(x)=\operatorname{p})+(1-\rho)$$
$$\operatorname{t}(x)=\mathbf{N}\mid\mathbf{c}(x)=\mathbf{n})$$
$$x_{t}=\rho\bullet.$$

 = ρ - Pr(t(x) = P | c(x) = p) + (1 - ρ) - Pr(t(x) = N | c(x) = n) [1] 
Many classifiers produce not only a classification, but also estimates of the probability that x will take on each class value. Let Postt(x) be classifier t's estimated (posterior) probability that for instance x, c(x) = p. Classifiers that produce class-membership probabilities produce a classification by applying a numeric threshold to the posterior probabilities. For example, a threshold value of .5 may be used so that t(x) = P *iff* Postt (x) > .5; otherwise t(x) = N. 

A variety of classifiers function by partitioning the input space into a set L of disjoint regions 
(a region being defined by a set of potential instances). For example, for a classification tree, the regions are described by conjoining the conditions leading to the leaves of the tree. Each region L ∈ L will contain some number of training instances, λL. Let λLp and λLn be the numbers of positive and negative training instances in region L, such that λL = λLp + λLn
. Such classifiers 