Laplace estimate often is used instead. We consider a version based on the Laplace law of succession (Good, 1965). This probability estimate will always be closer to 0.5 than the frequencybased estimate, but the difference between the two estimates will be negligible for large sample sizes. 

| Estimate Name               | Uncorrected           | Corrected              |
|-----------------------------|-----------------------|------------------------|
| Frequency-Based             | λLp /( λLp+λLn )      | λLp /( λLp+o λLn )     |
| Laplace (law of succession) | (λLp+1)/( λLp+ λLn+2) | (λLp+1)/( λLp+o λLn+2) |

Table 1: Probability Estimates for Observing a Minority-Class Example The corrected versions of the estimates in Table 1 account for differences between rtrain and ρ by factoring in the over-sampling ratio o, which measures the degree to which the minority class is over-sampled in the training set relative to the naturally occurring distribution. The value of o is computed as the ratio of minority-class examples to majority-class examples in the training set divided by the same ratio in the naturally occurring class distribution. If the ratio of minority to majority examples were 1:2 in the training set and 1:6 in the naturally occurring distribution, then o would be 3. A learner can account properly for differences between rtrain and ρ by using the corrected estimates to calculate the posterior probabilities at L. 

As an example, if the ratio of minority-class examples to majority-class examples in the naturally occurring class distribution is 1:5 but the training distribution is modified so that the ratio is 1:1, then o is 1.0/0.2, or 5. For L to be labeled with the minority class the probability must be greater than 0.5, so, using the corrected frequency-based estimate, λLp
/(λLp+5λLn
) > 0.5, or, λLp> 5 λLn
. Thus, L is labeled with the minority class only if it covers o times as many minorityclass examples as majority-class examples. Note that in calculating o above we use the class ratios and not the fraction of examples belonging to the minority class (if we mistakenly used the latter in the above example, then o would be one-half divided by one-sixth, or 3). Using the class ratios substantially simplifies the formulas and leads to more easily understood estimates. Elkan 
(2001) provides a more complex, but equivalent, formula that uses fractions instead of ratios. In this discussion we assume that a good approximation of the true base rate is known. In some real-world situations this is not true and different methods are required to compensate for changes to the training set (Provost & Fawcett, 2001; Saerens et al., 2002). 

In order to demonstrate the importance of using the corrected estimates, Appendix A presents results comparing decision trees labeled using the uncorrected frequency-based estimate with trees using the corrected frequency-based estimate. This comparison shows that for a particular modification of the class distribution of the training sets (they are modified so that the classes are balanced), using the corrected estimates yields classifiers that substantially outperform classifiers labeled using the uncorrected estimate. In particular, over the twenty-six data sets used in our study, the corrected frequency-based estimate yields a relative reduction in error rate of 10.6%. 

Furthermore, for only one of the twenty-six data sets does the corrected estimate perform worse. Consequently it is critical to take the differences in the class distributions into account when labeling the leaves. Previous work on modifying the class distribution of the training set (Catlett, 1991; Chan & Stolfo, 1998; Japkowicz, 2002) did not take these differences into account and this undoubtedly affected the results. 