rows of Table 3 are used throughout this article to evaluate how various training-set class distributions affect the predictions made by the induced classifiers. Finally, the metrics in the second column of Table 3 are "complements" of the corresponding metrics in the first column, and can alternatively be computed by subtracting the value in the first column from 1. More specifically, proceeding from row 1 through 4, the metrics in column 1 (column 2) represent: 1) the accuracy 
(error rate) when classifying positive/minority examples, 2) the accuracy (error rate) when classifying negative/minority examples, 3) the accuracy (error rate) of the positive/minority predictions, and 4) the accuracy (error rate) of the negative/majority predictions.

| tp                 | True Positive Rate   | fn                        |                         |                           |      |                     |                     |
|--------------------|----------------------|---------------------------|-------------------------|---------------------------|------|---------------------|---------------------|
| TP = Pr(P|p)       | ≈ tp                 | fn                        | (recall or sensitivity) | FN = Pr(N|p)              | ≈ tp | fn                  | False Negative Rate |
| +                  | +                    |                           |                         |                           |      |                     |                     |
| tn                 | True Negative Rate   | fp                        |                         |                           |      |                     |                     |
| TN = Pr(N|n) ≈ tn  | fp                   | (specificity)             | FP = Pr(P|n)            | ≈ tn                      | fp   | False Positive Rate |                     |
| +                  | +                    |                           |                         |                           |      |                     |                     |
| PPV                | =                    | Pr(p|P)                   | ≈                       | Positive Predictive Value | fp   |                     |                     |
| (precision)        | PPV = Pr(n|P) ≈ tp   | fp                        |                         |                           |      |                     |                     |
| +                  |                      |                           |                         |                           |      |                     |                     |
| tp                 |                      |                           |                         |                           |      |                     |                     |
| tp                 | fp                   |                           |                         |                           |      |                     |                     |
| +                  | tn                   | fn                        |                         |                           |      |                     |                     |
| NPV = Pr(n|N) ≈ tn | fn                   | Negative Predictive Value | NPV =Pr(y|N) ≈ tn       | fn                        |      |                     |                     |
| +                  | +                    |                           |                         |                           |      |                     |                     |

We use two performance measures to gauge the *overall* performance of a classifier: classification accuracy and the area under the ROC curve (Bradley, 1997). Classification accuracy is (tp +
fp)/(tp + fp + tn + fn). This formula, which represents the fraction of examples that are correctly classified, is an estimate of the expected accuracy, αt
, defined earlier in equation 1. Throughout this article we specify classification accuracy in terms of error rate, which is 1 - accuracy. 

We consider classification accuracy in part because it is the most common evaluation metric in machine-learning research. However, using accuracy as a performance measure assumes that the target (marginal) class distribution is known and unchanging and, more importantly, that the error costs—the costs of a false positive and false negative—are equal. These assumptions are unrealistic in many domains (Provost et al., 1998). Furthermore, highly unbalanced data sets typically have highly non-uniform error costs that favor the minority class, which, as in the case of medical diagnosis and fraud detection, is the class of primary interest. The use of accuracy in these cases is particularly suspect since, as we discuss in Section 5.2, it is heavily biased to favor the majority class and therefore will sometimes generate classifiers that never predict the minority class. In such cases, Receiver Operating Characteristic (ROC) analysis is more appropriate 
(Swets et al., 2000; Bradley, 1997; Provost & Fawcett, 2001). When producing the ROC curves we use the Laplace estimate to estimate the probabilities at the leaves, since it has been shown to yield consistent improvements (Provost & Domingos, 2001). To assess the *overall* quality of a classifier we measure the fraction of the total area that falls under the ROC curve (AUC), which is equivalent to several other statistical measures for evaluating classification and ranking models 
(Hand, 1997). Larger AUC values indicate generally better classifier performance and, in particular, indicate a better ability to rank cases by likelihood of class membership. 