# Pddl2.1 : An Extension To Pddl **For Expressing Temporal** Planning Domains

Maria Fox **maria.fox@cis.strath.ac.uk** Derek Long **derek.long@cis.strath.ac.uk**
Department of Computer and Information Sciences University of Strathclyde, Glasgow, UK

## Abstract

In recent years research in the planning community has moved increasingly towards application of planners to realistic problems involving both time and many types of resources. For example, interest in planning demonstrated by the space research community has inspired work in observation scheduling, planetary rover exploration **and spacecraft**
control domains. Other temporal and resource-intensive domains including **logistics planning, plant control and manufacturing have also helped to focus the community on the**
modelling and reasoning issues that must be confronted to make planning technology meet the challenges of application.

The International Planning Competitions have acted as an important motivating force behind the progress that has been made in planning since 1998. The third competition
(held in 2002) set the planning community the challenge of handling time and numeric resources. This necessitated the development of a modelling language capable of expressing temporal and numeric properties of planning domains. In this paper we describe the language, pddl2.1**, that was used in the competition. We describe the syntax of the**
language, its formal semantics and the validation of concurrent plans. We observe that pddl2.1 **has considerable modelling power - exceeding the capabilities of current planning**
technology - and presents a number of important challenges to the research community.

## 1. Introduction

In 1998 Drew McDermott released a Planning Domain Description Language, pddl **(McDermott, 2000; McDermott & the AIPS-98 Planning Competition Committee, 1998), which**
has since become a community standard for the representation and exchange of planning domain models. Despite some dissatisfaction in the community with some of the **features**
of pddl **the language has enabled considerable progress to be made in planning research**
because of the ease with which systems sharing the standard can be compared and the enormous increase in availability of shared planning resources. The introduction of **pddl**
has facilitated the scientific development of planning.

Since 1998 there has been a decisive movement in the research community towards application of planning technology to realistic problems. The propositional puzzle domains of old are no longer considered adequate for demonstrating the utility of a planning system - modern planners must be able to reason about time and numeric quantities. Although several members of the community have been working on applications of **planning**
to real domains of this nature for some time (Laborie & Ghallab, 1995; Ghallab & Laruelle, 1994; Muscettola, 1994; Drabble & Tate, 1994; Wilkins, 1988) there has always been a gap