(define (domain metricVehicle)
(:requirements :strips :typing :fluents)
(:types vehicle location)
(:predicates (at ?v - vehicle ?p - location)
(accessible ?v - vehicle ?p1 ?p2 - location))
(:functions (fuel-level ?v - vehicle)
(fuel-used ?v - vehicle)
(fuel-required ?p1 ?p2 - location)
(total-fuel-used))
(:action drive
:parameters (?v - vehicle ?from ?to - location)
:precondition (and (at ?v ?from)
(accessible ?v ?from ?to)
(>= (fuel-level ?v) (fuel-required ?from ?to)))
:effect (and (not (at ?v ?from))
(at ?v ?to)
(decrease (fuel-level ?v) (fuel-required ?from ?to))
(increase (total-fuel-used) (fuel-required ?from ?to))
(increase (fuel-used ?v) (fuel-required ?from ?to)))
)
) (define (problem metricVehicle-example)
(:domain metricVehicle)
(:objects truck car - vehicle Paris Berlin Rome Madrid - location)
(:init
(at truck Rome)
(at car Paris)
(= (fuel-level truck) 100)
(= (fuel-level car) 100) (accessible car Paris Berlin)
(accessible car Berlin Rome)
(accessible car Rome Madrid)
(accessible truck Rome Paris)
(accessible truck Rome Berlin) (accessible truck Berlin Paris)
(= (fuel-required Paris Berlin) 40)
(= (fuel-required Berlin Rome) 30)
(= (fuel-required Rome Madrid) 50)
(= (fuel-required Rome Paris) 35) (= (fuel-required Rome Berlin) 40) (= (fuel-required Berlin Paris) 40) (= (total-fuel-used) 0)
(= (fuel-used car) 0)
(= (fuel-used truck) 0)
)
(:goal (and (at truck Paris)
(at car Rome))
)
(:metric minimize (total-fuel-used))
)
Figure 5: An example of a domain and problem instance describing a plan metric.