must attempt to use as few actions to solve a problem as possible. In fact, even this case is a little more complex than it appears - there can be rival plans in which one **uses** more actions but has lower overall cost than the other. A more complex case arises when some actions improve the quality metric while others degrade it. For example, if we use the maximising metric but also add a refuel action to the domain then driving will degrade plan quality (by reducing the fuel level of a vehicle) but refuelling will improve plan quality (by increasing the fuel level of a vehicle). In this case, a planner can attempt to use actions to improve the plan quality without those actions actually contributing to achieving the goals. For example, refuelling might not be necessary to get the vehicles to their destinations, but adding refuelling actions would improve the quality of a solution. **This process could** involve trading off finite and irreplaceable resources for the increased value of the plan. This would be the case if, for example, refuelling a vehicle took fuel **from a finite reservoir.**
Alternatively a domain could allow plans of arbitrarily high value to be constructed by using more and more actions. This would occur in the metric vehicles domain using the maximising vehicle's fuel level metric if refuelling were not constrained, since the domain does not impose a limit on the fuel capacities of the vehicles.

The case in which plans are constrained by finite availability of resources, is an important and interesting form of the planning problem, but the case in which plans of **arbitrarily**
high utility can be constructed, is obviously an ill-defined problem, since an optimal plan does not exist. It is non-trivial to determine whether a planning problem provided with a metric is ill-defined. In fact, as Helmert shows (Helmert, 2002), the introduction of numeric expressions, even in the constrained way that we have adopted in pddl2.1**, makes the**
planning problem undecidable. The problem of finding a collection of actions which does not consume irreplaceable resources and has an overall beneficial impact **on a plan metric**
is at least as hard as the planning problem. Therefore it is clear that determining whether a planning problem is even well-defined is undecidable. This does not make it worthless to consider planning with metrics, of course, but it demonstrates that the modelling problem, as well as the planning problem, becomes even more complex when metrics **are introduced.**
One strategy available to planners working with problems subject to plan metrics is to ignore the metric and simply produce a plan to satisfy the logical goals that a problem specifies. In this case, the plan quality will simply be the value, according to the metric, of the plan that happens to be constructed. This strategy is unsophisticated and it is obviously better for a planner to construct a plan guided by the specified metric. How best to use a metric to expedite the search process in a fully-automated planner is still a research issue.

## 5. Durative Actions

Most recent work on temporal planning (Smith & Weld, 1999; Bacchus & Kabanza, 2000; Do & Kambhampati, 2001) has been based on various forms of durative action. In order to facilitate participation in the competition we therefore developed two forms of **durative** action allowing the specification only of restricted forms of timed conditions and **effects** in their description. Although constrained in certain ways, these durative **actions are,** nevertheless, more expressive than many of the proposals previously explored, particularly in the way that they allow concurrency to be exploited. The two forms are **discretised** durative actions and continuous **durative actions.**