(:durative-action load-truck
:parameters (?t - truck)
(?l - location)
(?o - cargo)
(?c - crane)
:duration (= ?duration 5)
:condition (and (at start (at ?t ?l))
(at start (at ?o ?l))
(at start (empty ?c) (over all (at ?t ?l)) (at end (holding ?c ?o))
:effect (and (at end (in ?o ?t))
(at start (holding ?c ?o))
(at start (not (at ?o ?l)))
(at end (not (holding ?c ?o)))
)
Both forms rely on a basic durative action structure consisting of the logical changes caused by application of the action. We always consider logical change to be instantaneous, therefore the continuous aspects of a continuous durative action refer only to how **numeric** values change over the interval of the action. Figure 6 depicts a basic durative **action,** load-truck**, in which there is no numeric change.**
The modelling of temporal relationships in a discretised durative action is done by means of temporally annotated **conditions and effects. All conditions and effects of durative actions**
must be temporally annotated. The annotation of a condition makes explicit whether the associated proposition must hold at the start **of the interval (the point at which the action**
is applied), the end **of the interval (the point at which the final effects of the action are** asserted) or over the interval from the start to the end (invariant over the duration of the action). The annotation of an effect makes explicit whether the effect is immediate (it happens at the start of the interval) or delayed (it happens at the end of the interval). No other time points are accessible, so all discrete activity takes place at the identified start and end points of the actions in the plan.

Invariant conditions in a durative action are required to hold over an interval that is open at both ends (starting and ending at the end points of the action). These are expressed using the over all **construct seen in Figures 6 and 8. If one wants to specify that a fact** p holds in the closed interval over the duration of a durative action, then three conditions are required: (at start p), (over all p) and **(at end p)**.

We considered adopting the convention that over all **constraints should apply to the**
start and end points as well as the open interval inside the durative action, but **decided** against this because it would then be impossible to express conditions that are actually only required to hold over this open interval. Examples of actions in which **conditions are** invariant only over the open interval include the action of loading a truck. The truck must remain at the loading location throughout the loading interval, but it can start to move away simultaneously with the loading being completed. The reason is that the **start of the**