drive action is non-mutex with the end of the load so there is a reasonable interpretation of any plan in which driving starts at the instant that loading is completed. Actions **that affect** an invariant condition (such as the location of the truck) can be executed simultaneously with the end point of a durative action only if the invariant is not constrained to **hold true** at the end point itself. This highlights an important difference between (over all) and (**over**
all and at end**). If a condition is required as an end precondition as well as an invariant** condition the meaning is that any action that affects the invariant must start after the end of the action requiring that invariant. For example, if we make (at truck location) **an end** precondition of the load operator as well as an invariant, the consequence is that the truck cannot drive away until after the instant at which the load has completed.

Note that, in our definition of the load-truck **action in Figure 6, we have chosen to make**
the condition (holding ?c ?o) **be a start effect and an end precondition but not an invariant**
condition. This means that the crane could temporarily cease to hold the cargo at some time during the interval, as long as it is holding the cargo in time to deposit it at the end of the loading interval. This makes the action quite flexible, enabling the exploitation of concurrent uses of the crane where applicable.

The load-truck **example shows how logical change can be wrapped up into durative**
actions that encapsulate much of the detail involved in achieving an effect by a **sequence**
of connected activities. Naturally it would be useful to be able to combine such actions concurrently within a plan. In the next section we consider the extent **to which concurrency** is allowed and the ways in which concurrent plans are interpreted.

## 5.1 The Interpretation Of Concurrent Plans

When time is introduced into the modelling of a domain it is possible for concurrent activity to occur in a plan. Prior to the introduction of time into pddl **all plans were interpreted**
as sequential - even Graphplan-concurrent plans were sequenced before being validated —
so concurrency was never an issue. In pddl2.1 **plan validity can depend on exploiting**
concurrency correctly. Actions can overlap and co-occur, giving rise to questions over the interpretation of synchronous behaviour. We discuss the problems arising in precise synchronization in Section 10. We now explain under what constraints actions can **occur** concurrently within a plan involving durative actions and numeric conditions and effects.

The key difference, between durative actions in pddl2.1 **and those used by planners prior**
to the competition, is that we distinguish between the conditions and effects at **the start** and end points of the durative interval and the invariant conditions that might be **specified**
to hold over the interval. That is, actions can have pre- and postconditions that are local to the two end-points of the action, and a planner can choose to exploit a durative **action**
for effects it has at its start or at its end. Conditions that are invariant are distinguished from pre-conditions, enabling the exploitation of a higher degree of concurrency than is possible if preconditions are not distinguished from invariants, as in tgp **(Smith & Weld,** 1999), tpsys (Garrido, Onaind´ıa, & Barber, 2001) and tp4 **(Haslum & Geffner, 2001).**
We discuss the consequences of these design decisions, together with several examples of durative actions, in the following sections.

It is important to observe that our view of time is point-based rather than interval-based.

That is, we see a period of activity in terms of intervals of state separated by time points