(:durative-action heat-water
:parameters (?p - pan)
:duration (= ?duration (/ (- 100 (temperature ?p)) (heat-rate)))
:condition (and (at start (full ?p))
(at start (onHeatSource ?p))
(at start (byPan))
(over all (full ?p))
(over all (onHeatSource ?p))
(over all (heating ?p)) (at end (byPan)))
:effect (and (at start (heating ?p))
(at end (not (heating ?p)))
(at end (assign (temperature ?p) 100)))
)
Figure 7: A simple durative action for boiling a pan of water.

Planners can exploit considerable concurrency in a domain by ensuring only that conflicting start and end points of actions are separated by a non-zero amount. A detailed specification of the mutual exclusion relation of pddl2.1 **is given in Section 8. We further**
discuss the implications of non-zero separation in Section 10.

## 5.2 Numeric Change Within Discretised Durative Actions

This section explains how continuous change can sometimes be modelled in pddl2.1 **using**
durative actions with discrete effects. This is achieved by using step functions to describe instantaneous changes at the beginnings or ends of the durations of actions. Appendix A details the language constructs involved.

An example of a durative action, illustrating the use of numeric update operations, is shown in Figure 7. In this example showing a water heating action, the conditions **(full ?p)**
and (onHeatSource ?p) **must hold at the start of the interval as well as during the interval.**
To model this we enter these conditions as both at start and over all **constraints. The**
action achieves as its start effect that the water is heating, and this condition is maintained invariant over the whole interval of the action. This is an example of an operator that achieves its own invariant condition, and draws attention to the fact that over all **conditions** hold over an interval that is open on the left (as well as on the right).

It should be noted that the actions in Figures 7 and 8 use fixed duration specifications.

In the case of the water-boiling example this means that it is impossible to adjust the length of time over which the pan is heated and this has an impact on the context in which the action can be used. In particular, when an assign **construct is used to update a numeric** value, it is not possible for concurrent activity to affect the same value or else the model will be flawed. Because the water heating example uses an assign **construct no concurrent** activity should affect the temperature of the water. It is the responsibility **of the modeller** to ensure that the temperature is neither accessed nor updated during the **interval over** which the action is executing.