(:durative-action navigate
:parameters (?x - rover ?y - waypoint ?z - waypoint)
:duration (= ?duration (travel-time ?y ?z))
:condition (and (at start (available ?x))
(at start (at ?x ?y))
(at start (>= (energy ?x)
(* (travel-time ?y ?z) (use-rate ?x))))
(over all (visible ?y ?z))
(over all (can_traverse ?x ?y ?z)))
:effect (and (at start (decrease (energy ?x)
(* (travel-time ?y ?z) (use-rate ?x))))
(at start (not (at ?x ?y)))
(at end (at ?x ?z))))
(:durative-action recharge
:parameters (?x - rover ?w - waypoint) :duration (= ?duration (recharge-period ?x))
:condition (and (at start (at ?x ?w))
(at start (in-sun ?w))
(at start (<= (energy ?x) (capacity ?x)))
(over all (at ?x ?w)))
:effect (at end (increase (energy ?x) (* ?duration (recharge-rate ?x)))))
Figure 8: Discretised durative actions for a rover to move between locations **and to recharge.**
We decided to leave it to the modeller to ensure correct behaviour of the assign **construct because we did not want to forbid the modelling of truly discontinuous updates. For**
example, a durative action that models the deposit of a cheque in a bank account might have a duration of three days, with a discontinuous update to the account balance **at the** end of that interval - it would be inappropriate to prevent actions from accessing the balance during the three day period. In general, modelling continuous change with discrete effects is open to various pitfalls. This is the price that is paid for the convenience of not having to specify the details of the continuous processes.

The use of discretised durative actions in combination with numeric (step-function)
updates requires care in modelling. In particular, it relies on the notion of **conservative**
resource updating**. The updating of resource levels is conservative if the consumption of**
a resource is modelled as if it happens at the start of a durative action, even though it actually happens continuously over the duration of the action, and production of a resource is modelled as if it happens at the end of the durative action even though, again, **it might**
actually be produced continuously over the interval.

As an example of a discretised durative action, Figure 8 shows how the action of a rover navigating between two points is modelled. The local precondition of the start of the period is that the rover be at the start location. Local effects include that **the rover** consumes an appropriate amount of energy and that it is at the destination. The first of these is conservative and therefore immediate, while the second is a logical effect that occurs at the end point. This organisation ensures that no parallel activities will consume energy that has already been committed to the navigation activity. Similarly, the recharge action