
## 5.3 Durative Actions With Continuous Effects

The objective of discrete durative actions is to abstract out continuous change and **concentrate on the end points of the period over which change takes place. The syntax allows**
precise specification of the discrete changes at the end points of durative actions. However, when a plan needs to manage continuously changing values, as well as discretely changing ones, the durative action language and semantics need to be more powerful. General durative actions can have continuous as well as discrete effects. These increase, or decrease, some numeric variable according to a specified rate of change over time for that **variable.**
When determining how to achieve a goal a planner must be able to access the values of these continuous quantities at arbitrary points on the time-line of the plan. We use \#t **to refer**
to the continuously changing time from the start of a durative action during its execution. For example, to express the fact that the fuel level of a plane, ?p**, decreases continuously,**
as a function of the consumption rate of ?p**, we write:**
(decrease (fuel-level ?p) (* \#t (consumption-rate ?p)))
This is distinctly different from:

(at end (decrease (fuel-level ?p) (* (flight-time ?a?b) (consumption-rate ?p))))
because the latter is a single update happening at the end point of the flight action, whilst the former allows the correct calculation of the fuel level of the plane at any point in that interval. The former is a continuous effect, whilst the latter is a discrete one. Continuous effects are not temporally annotated because they can be evaluated at any time during the interval of the action. \#t **is local to each durative action, so that each durative action** has access to a purely local "clock". Another way to interpret the expression representing continuous change is as a differential equation:

$${\frac{d}{d t}}\,(\,\mathrm{fuel\_level\_?p})\,=\,(\,\mathrm{consumption\_rate\_?p})$$

We chose to use the \#t **symbol instead of a differential equation because it is possible for two**
concurrent actions to be simultaneously modifying the same quantity. In **that case, the use** of differential equations would actually form an inconsistent pair of simultaneous equations, rather than having the intended effect of a combined contribution to the changing value of the quantity. Although all of the expressions describing continuous change take **the form of a** product of \#t **and some quantity, it is possible to express complex change using them with** interdependent concurrent effects. For example, acceleration arises **by simply increasing**
distance using a quantity describing velocity, while at the same time **increasing velocity** using a quantity describing acceleration. When dependencies between the changing terms include mutual dependencies between terms then the differential equations that arise can lead to continuous change dictated by exponential, logarithmic and exponential functions.

A plan containing continuous durative actions can assign to, consult, and continuously modify the same numeric variables concurrently (see Example 1).

In Figures 12 and 14 the discrete and continuous actions for heating a pan of water are presented (this simple model ignores heat loss). The discrete action presented in Figure 12 modifies the version presented in Figure 7 by the use of a duration inequality **constraint.**