Example 1 **In the flying and refuelling example shown in Figure 11 it can be seen**
that the invariant condition, that the fuel-level be greater than (or equal to) zero during the flight, has to be maintained whilst the fuel is continuously decreasing. This could be expressed with discrete durative actions by abstracting out the continuous decrease and making the final value available at the end point of the flight. However, if a refuel operation happens during the flight time (in mid-air) then the fuel level after the flight will need to be calculated by taking into account both the continuous rate of consumption and the refuel operation. A discrete action could not calculate the fuel-level correctly because it would only have access to the distance between the source and destination of the flight, together with the rate of consumption, to determine the final fuel level. In order to calculate the fuel level correctly it is necessary to determine the time at which the refuel takes place, and to use the remaining flight-time to calculate the fuel consumed. Discrete durative actions do not give access to time points other than their own start and end points. Discrete durative actions can be used to express the desired combinations of flying and refuelling by providing additional durative actions, such as fly-and-refuel, that encapsulate all of the interactions just described and end up calculating the fuel level correctly. However, this approach requires more of the domain designer than it does of the planner - the domain designer must anticipate every useful combination of behaviours and ensure that appropriate encapsulations are provided.

In contrast with the discrete form, the continuous action, in which the fuel consumption effect is given in terms of \#t**, is powerful enough to express the fact that the**
mid-flight refuelling of the plane affects the final fuel level in a way consistent with maintaining the invariant of the fly action.

(:durative-action fly
:parameters (?p - airplane ?a ?b - airport)
:duration (= ?duration (flight-time ?a ?b))
:condition (and (at start (at ?p ?a))
(over all (inflight ?p)) (over all (>= (fuel-level ?p) 0)))
:effect (and (at start (not (at ?p ?a)))
(at start (inflight ?p))
(at end (not (inflight ?p)))
(at end (at ?p ?b)) (decrease (fuel-level ?p)
(* \#t (fuel-consumption-rate ?p)))))
(:action midair-refuel
:parameters (?p) :precondition (inflight ?p) :effect (assign (fuel-level ?p) (fuel-capacity ?p)))
Figure 11: A continuous durative action for flying.