(:durative-action heat-water
:parameters (?p - pan)
:duration (at end (<= ?duration (/ (- 100 (temperature ?p))
(heat-rate))))
:condition (and (at start (full ?p))
(at start (onHeatSource ?p))
(at start (byPan))
(over all (full ?p))
(over all (onHeatSource ?p)) (over all (heating ?p)) (at end (byPan)))
:effect (and (at start (heating ?p))
(at end (not (heating ?p)))
(at end (increase (temperature ?p)
(* ?duration (heat-rate)))))
)
Figure 12: A discrete durative action for heating a pan of water, using a variable duration. Duration inequalities add significant expressive power over duration equalities. Duration constraints that express inequalities are associated with an additional requirements flag because of the extended expressiveness over fixed-duration discrete durative actions.

In both actions, the logical post-condition of the start of the period is that the pan is heating. The conditions that the pan be heating, full and on the heat source are invariant, although the presence of the agent (by the pan) is only a local precondition of the two end-points and is not invariant. In the first action the duration is modelled by expressing the following duration inequality constraint:
(at end (<= ?duration (/ (- 100 (temperature ?p)) (heat-rate))))
and the effect at the end-point of the discrete durative action is that the temperature of the pan is increased by (* ?duration (heat-rate)) **(where** heat-rate **is a domain** constant). In the continuous action of Figure 14 the duration constraint is unnecessary since the invariant
(over all (<= (temperature ?p) 100))
is added to ensure that the pan never exceeds boiling.

The durative action in Figure 12 models the heating pan in the face of possible concurrent activities affecting the temperature. The duration inequality allows the planner to adapt the duration to take account of other temperature-affecting activity in a way that is not possible when the duration is specified using an equality constraint. The duration constraint ensures that the temperature never exceeds boiling by checking, as a precondition for the updating activity, that the computed temperature increase can be executed without exceeding the boiling point. If this temperature increase would exceed boiling the plan is invalid. The temperature at the end of the interval of execution is computed from the current temperature and the heating rate, together with the duration over which the heating action has been active (see further discussion in Example 2).