(:durative-action heat-water
:parameters (?p - pan)
:duration ()
:condition (and (at start (full ?p))
(at start (onHeatSource ?p))
(at start (byPan))
(over all (full ?p))
(over all (onHeatSource ?p)) (over all (heating ?p))
(over all (<= (temperature ?p) 100))
(at end (byPan)))
:effect (and (at start (heating ?p))
(at end (not (heating ?p)))
(increase (temperature ?p) (* \#t (heat-rate))))
)
The use of duration inequalities adds significant expressive power even when using discrete durative actions. For example, the plan depicted in part (a) of Figure 13, **which** illustrates the use of the water-heating action shown in Figure 12 while concurrently heating the pan with a blowtorch, will be considered valid provided that there is a duration value that satisfies the duration constraint in the water-heating action. This brings us very close to the expressive power available with continuous durative actions because it gives the planner the power to exploit concurrent interacting activities enacting changes on the same numeric valued variable (see Example 3). Attempting to express continuous change using only duration inequalities does not give precisely equivalent behaviour, because the discretisation forces actions that access changing numeric values to be separated, by some small temporal interval, from the actions that change those values in order to resolve their mutual exclusion. In a continuous model this is not necessary because the true value of a numeric variable is available for consultation at any time during the continuous process of change.

In the discrete semantics presented in Section 8 we exploit the fact that the only changes that can occur when a plan is executed are at points corresponding to the times **of happenings, so the plan can be checked by looking at the activity focussed in this finite happening**
sequence. In fact, provided continuous effects are restricted to linear functions of time with only first order effects (which requires that no continuous effects can affect numeric expressions contributing to the rate of change of another numeric valued variable), and invariants are restricted to linear functions of changing quantities, it is still possible to restrict attention to the happening sequence even when using continuous actions.

Non-linear effects and higher-order rates of change create difficulties since it is possible for an invariant to be satisfied at the end points of an interval, without having necessarily been satisfied throughout the interval. In these cases it is no longer sufficient to insert invariant checking actions at fixed mid-points in the happening sequence of a plan in order to validate its behaviour. However, provided that effects are first-order and **linear, and** invariants are linear in continuously changing values, then, despite the fact that arbitrary