Example 3 **It is possible with discrete durative actions, with duration inequalities,**
to model the effects of adding an egg to the heating water when the water is at, say, 90 degrees. We do this by applying two heat-water actions, around an add-egg action, in such a way that the overall duration of the two heat-water actions is exactly the duration required to boil the water from its original temperature. However, the way the heat-water action is currently modelled means that the heat will be turned off before the egg is added, and then turned on again to complete the heating, since the temperature is only updated when the durative action terminates. With continuous durative actions the egg can be added whilst the single heat-water action is in progress since the temperature of the pan is continuously updated. So, discrete durative actions with duration inequalities allow us to approximate continuous activity by appending a finite sequence of discrete intervals in an appropriate way. The no moving targets rule means that the end points of these intervals will be separated by non-zero, arbitrarily small, time gaps. This is not required when using continuous actions because, in contrast to the step-function effects of discrete actions, continuous effects are not localised at a single point.

time points within action intervals are accessible to the planner, it is only **necessary to gain** access to numeric values at the start- and end-points of the actions in the plan that refer to them, together with finitely many mid-points for invariant-checking actions. The values are not required at all other points. This is so because continuous durative actions do not support the modelling of exogenous events, so it is not necessary to take into account the exogenous activity of the environment in determining the validity of a plan.

## 5.4 Related Approaches

Time is an important numerically varying quantity. The simplest way to **reason about time** is to adopt a black box **durative action model in which change happens at the ends of their** durative intervals. This is the approach taken in the language used by TGP (Smith &
Weld, 1999), for example, in which durative actions encapsulate continuous change **so that**
the correct values of any affected variables are guaranteed only at the end points of the implied intervals. All of the logical and numeric effects of a durative action are enacted at the end of the action and are undefined during the interval of its execution. All undeleted preconditions must remain true throughout the interval. There is no syntactic distinction between preconditions and invariant **conditions in this action representation. A simplistic** way of ensuring correct action application is to prevent concurrent actions **that refer to the** same facts, but this excludes many intuitively valid plans.

A more sophisticated approach allows preconditions to be annotated with time points, or intervals, so that the requirement that a condition be true at some point, or over some interval, within the duration of the action can be expressed. This is the approach taken in Sapa (Do & Kambhampati, 2001). For example, using such an annotated precondition it would be possible to express the requirement that some chemical additive be added within two minutes of the start of a tank-filling action. If effects can also be specified to occur at arbitrary points within the duration of the action then it is possible to express **effects that**