occur before the end of the specified duration. It is also possible to distinguish between conditions that are local to specific points in the duration of the action and those that are invariant throughout the action.

Allowing reference to finitely many time points between the start and end of **actions**
makes the language more complex without adding to its expressive power. **Where time**
points are strictly scheduled relative to the start of the action the effect can be achieved through the use of a sequence of linked durative actions. We decided to keep **pddl2.1**
simple by restricting access to only the end points of actions.

In TLPlan (Bacchus & Ady, 2001) a similar, but more constrained, approach is adopted in which actions are applied instantaneously but can have delayed effects. **The delays for** effects can be arbitrary and different for each effect. However, invariants cannot be specified because the preconditions are checked at the instant of application and subsequent delayed effects are separated from the action which initiated them.

Several planners have been developed to use networks of temporal constraints (Ghallab
& Laruelle, 1994; Jonsson, Morris, Muscettola, & Rajan, 2000; El-Kholy & Richards, 1996)
to handle temporal structure in planning problems. Efficient algorithms exist for handling such constraints (Dechter, Meiri, & Pearl, 1991) which make them practical for managing large networks. The domain models constructed using pddl2.1 **certainly lend themselves**
to treatment by similar techniques, but are not constrained to be handled in this way.

## 6. Introduction To The Semantics Of **Pddl2.1**

In Sections 7 and 8 we provide a formal semantics for the numeric extension and temporal extension of pddl2.1**. Together these sections contain 20 definitions. The lengthy treatment**
is necessary because the semantics we have developed adds four significant extensions over classical planning and the semantics Lifschitz developed for strips **(Lifschitz, 1986). These**
are:
- **the introduction of time, so that plans describe behaviour relative to a real time line;**

- **related to the first extension, the treatment of concurrency - actions can be executed**
in parallel, which can lead to plans that contain concurrent interacting processes
(although these processes are encapsulated in durative actions in **pddl2.1**);
- **an extension to handle numeric-valued fluents;**
- **the use of conditional effects, both alone and in conjunction with all of the above**
extensions.
The semantics is built on a familiar state-transition model. The requirements of the semantics can be reduced to four essential elements.

1. To define what is a state. The introduction of both time and numeric values complicate the usual definition of a state as a set of atoms.

2. To define when a state satisfies a propositional formula representing a goal condition or precondition of an action. An extension of the usual interpretation of a state as a valuation in which an atom is true if and only if the atom is in the state (the Closed World Assumption) is required in order to handle the numeric values in the state.