The assignment proposition **corresponding to a numeric effect is formed by replacing**
the assignment operator with its equivalent arithmetic operation (that is (increase p q) becomes (= p (+ p q)) **and so on) and then annotating the lvalue with a "prime".**
A numeric effect in which the assignment operator is either increase or decrease is called an additive assignment effect**, one in which the operator is either** scale-up or scale-down is called a scaling assignment effect and all others are called **simple assignment** effects.

A numeric effect defines a function of the numeric values in the state to which an action is applied determining the value of a primitive numeric expression **in the resulting state.**
For the convenience of a uniform treatment of numeric expressions appearing in pre- and post-conditions, we transform the functions into propositions that assert the equality of the post-condition value and the expression that is intended to define it. That is, **rather than**
writing an effect (increase p q) as a function f(p) = p+q**, we write it as the proposition**
(= p
′(+ p q**)). The "priming" distinguishes the postcondition value of a primitive numeric**
expression from its precondition value (a convention commonly adopted in describing state transition effects on numeric values). The binding of the primitive numeric expressions to their values in states is defined in the following definition.

Definition 4 Normalisation Let I be a planning instance of dimension dimI **and let**

## Indexi : P Nesi → {1**, . . . , Dim**}

be an (instance-dependent) correspondence between the primitive numeric expressions and integer indices into the elements of a vector of dimI **real values,** R
dimI

⊥.

The normalised form of a ground proposition, p, in I is defined to be the result of substituting for each primitive numeric expression f in p**, the literal** XindexI (f)**. The normalised**
form of p will be referred to as N (p)**. Numeric effects are normalised by first converting**
them into assignment propositions. Primed primitive numeric expressions are replaced with their corresponding primed literals. X is used to represent the vector hX1 **. . . X**ni.

In Definition 4, the replacement of primitive numeric expressions with indexed literals allows convenient and consistent substitution of the vector of actual parameters **for the**
vector of literals X **appearing in a state.**
With the machinery supporting treatment of numeric expressions complete, it is now possible to consider the process of instantiating action schemas. This process is managed in two steps. The first step is to remove constructs that we treat as syntactic sugar in the definition of a domain. These are conditional effects and quantified formulae. We **handle** both of these by direct syntactic transformations of each action schema into a set **of action** schemas considered to be equivalent. The transformation is similar to that described by Gazen and Knoblock (1997). Although it would be possible to give a semantic interpretation of the application of conditional effects directly, the transformation allows us to significantly simplify the question of what actions can be performed concurrently.

Definition 5 Flattening Actions Given a planning instance, I**, containing an action**
schema A ∈ AsI , the set of action schemas flatten(A), is defined to be the set S**, initially**
containing A **and constructed as follows:**