have to apply collections of concurrent updating functions to the primitive **numeric expressions. This can be allowed provided that the functions commute. Additive assignments do**
commute, but other updating operations cannot be guaranteed to do so, except if they do not affect the same primitive numeric expressions or rely on primitive numeric expressions that are affected by other concurrent assignment propositions. It would be possible to make a similar exception for scaling effects, but additive assignment effects **have a particularly** important role in durative actions that is not shared by scaling effects, so for simplicity we allow concurrent updates only with these effects. We use the three sets **of primitive** numeric expressions to determine whether we are in a safe situation or not. Within a single action it is possible for the rvalues and lvalues to intersect. That is, an action **can update** primitive numeric expressions using current values of primitive **numeric expressions that** are also updated by the same action. All rvalues will have the values they take in the state prior to execution and all lvalues will supply the new values for the state that **follows.**
Definition 9 Satisfaction of Propositions Given a logical state, s, a ground propositional formula of pddl2.1, p**, defines a predicate on** R
dim
⊥, Num(s, p)**, as follows:**
Num(s, p)(x) iff s |= N (p)[X := x]
where s |= q means that q is true under the interpretation in which each atom, a**, that is not** a numeric comparison, is assigned true iff a ∈ s**, each numeric comparison is interpreted**
using standard equality and ordering for reals and logical connectives are given their usual interpretations. p is satisfied in a state (t, s, X) if Num(**s, p**)(X).

Comparisons involving ⊥, including direct equality between two ⊥ **values are all undefined, so that enclosing propositions are also undefined and not satisfied in any state.**
Definition 10 Applicability of an Action Let a be a ground action. a is **applicable** in a state s if the P rea **is satisfied in** s.

## 7.1 Semantics Of A Simple Plan

A simple plan, in pddl2.1**, is a sequence of timed actions, where a timed action has the**
following syntactic form:
t : (action p1 **. . . p**n)
In this notation t **is a positive rational number in floating point syntax and the expression**
(action p1 . . . pn**) is the name and actual parameters of the action to be executed at that**
point in time. In more complex plans simple and durative actions, with or without numericvalued effects or preconditions, can co-occur - the semantics of such plans is discussed in Section 8. No special separators are required to separate timed actions in the sequence and the actions are not required to be presented in time-sorted order. It is possible for multiple actions to be given the same time stamp, indicating that they should be executed concurrently. It should be emphasised that the earliest point at which activity occurs within a plan must be strictly after time 0. This constraint follows from the decision to make the initial state be the state existing at time 0, together with the decision, in the semantics, that actions have their effects in the interval that is closed on the left**, starting at the time** when the action is applied, while preconditions are tested in the interval that is **open on the** right **that precedes the action.**