In order to retain compatibility with the output of current planners the following concession is made: if the plan is presented as a sequence of actions with no time points, then it is inferred that the first action is applied at time 1 and the succeeding **actions apply in**
sequence at integral time points one unit apart.

A simple plan is a slight generalisation of the more familiar strips**-style classical plan,**
since actions are labelled with the time at which they are to be executed.

Definition 11 Simple Plan A simple plan, SP, for a planning instance, I**, consists of a**
finite collection of timed simple actions which are pairs (t, a), where t **is a rational-valued** time and a **is an action name.**
The **happening sequence**, {ti}i=0...k for SP **is the ordered sequence of times in the set**
of times appearing in the timed simple actions in SP. All ti must be greater than 0**. It is**
possible for the sequence to be empty (an empty plan).

The happening at time t, Et, where t is in the happening sequence of SP**, is the set of**
(simple) action names that appear in timed simple actions associated with the time t in SP.

A plan thus consists of a sequence of happenings, each being a set of action names applied concurrently at a specific time, the sequence being ordered in time. The times at which these happenings occur forms the happening sequence. It should be noted that action names are ambiguous when action schemas contain conditional effects - the consequence of flattening is to have split these actions into multiple actions with identical names, differentiated by their preconditions. However, at most one of each set of actions with identical names can be applicable in a given logical state, since the precondition of each action in **such a set** will necessarily be inconsistent with the precondition of any other action in **the set, due to**
the way in which the conditional effects are distributed between the pairs of **action schemas** they induce.

In order to handle concurrent actions we need to define the situations in which the effects of those actions are consistent with one another. This issue was first discussed in Section 5.1. The mutual exclusion rule for pddl2.1 is an extension of the idea of **action**
mutex **conditions for GraphPlan (Blum & Furst, 1995). The extension handles two extra**
features: the extended expressive power of the language (to include arbitrary propositional connectives) and the introduction of numeric expressions. We make a very conservative condition for actions to be executed concurrently, which ensures that there **is no possibility**
of interaction. This rules out cases where intuition might suppose that concurrency is possible. For example, the actions:
(:action a
:precondition (or p q)
:effect (r))
(:action b
:precondition (p)
:effect (and (not p) (s)))
could, one might suppose, be executed simultaneously in a state in which both p and q **hold.** The following definition asserts, however, that the two actions are mutex. The reason we have chosen such a constrained definition is because checking for mutex **actions must be**