tractable and handling the case implied by this example would appear to require checking the consequence of interleaving preconditions and effects in all possible orderings. The condition on primitive numeric expressions has already been discussed - it determines that the update effects can be executed concurrently and that they do not affect values which are then tested by preconditions (regardless of whether the results of **those tests**
matter to the satisfaction of their enclosing proposition). This is the rule of **no moving** targets**: no concurrent actions can affect the parts of the state relevant to the precondition** tests of other actions in the set, regardless of whether those effects might be harmful or not. It might be considered odd that the preconditions of one action cannot refer to literals in the add effects of a concurrent action. We require this because preconditions can be negative, in which case their interaction with add effects is analogous to the interaction between positive preconditions and delete effects. The no moving targets rule makes the cost of determining whether a set of actions can be applied concurrently polynomial in the size of the set of actions and their pre- and post-conditions.

Definition 12 Mutex Actions Two grounded actions, a and b are **non-interfering** if

$$\begin{array}{c}{{\varepsilon_{a}\cap(A d d_{b}\cup D e l_{b})=G P r e_{b}\cap(A d d_{a}\cup D e l_{a})=\varnothing}}\\ {{A d d_{a}\cap D e l_{b}=A d d_{b}\cap D e l_{a}=\varnothing}}\\ {{L_{a}\cap R_{b}=R_{a}\cap L_{b}=\varnothing}}\\ {{L_{a}\cap L_{b}\subseteq L_{a}^{*}\cup L_{b}^{*}}}\end{array}$$

If two actions are not non-interfering they are **mutex**.

The last clause of this definition asserts that concurrent actions can only update the same values if they both do so by additive assignment effects.

We are now ready to define the conditions under which a simple plan is valid. We can separate the executability of a plan from whether it actually achieves the intended goal. We will say that a plan is valid if it is executable and **achieves the final goal. Executability**
is defined in terms of the sequence of states that the plan induces by sequentially executing the happenings that it defines.

Definition 13 Happening Execution Given a state, (t, s, x) and a happening, H**, the**
activity for H **is the set of grounded actions**
AH = {a|the name for a is in H, a is valid and P rea is satisfied in (**t, s,** x)}

The result of executing a happening, H, associated with time tH, in a state (**t, s,** x) is
undefined if |AH| 6= |H| or if any pair of actions in AH **is mutex. Otherwise, it is the state**
(tH, s′, x
′) **where**
$$s^{\prime}=(s\setminus\bigcup_{a\in A_{H}}{\cal D}e l_{a})\cup\bigcup_{a\in A_{H}}{\cal A}d d_{a}$$
and x
′is the result of applying the composition of the functions {NPFa | a ∈ AH} to x.

Since the functions {NPFa | a ∈ AH} **must affect different primitive numeric expressions,**
except where they represent additive assignment effects, these functions will commute and

$$t i o n s\ \{\mathrm{NPF}_{a}\,|\,a\in A_{H}\}\ t o n$$
