the trace, or by artificial modification of the plan itself to ensure that states carry extra information from the start to the end of the durative action. The latter approach has the disadvantage that as durative actions become more complex the artificial components that must be added to the plan become more intrusive. This is particularly apparent in the treatment of conditional effects that require conditions tested at the start of a durative action, or across its duration, but effects that are triggered at the end, since these **cases** require some sort of "memory" in the state to remember the status of the tested conditions from the start of the durative action to the end point. These memory conditions allow us to avoid embedding an entire execution history in a state by substituting an **ad hoc** memory of the history for just those propositions and at just those times it is required. The management of conditional effects of this form, in the mapping from durative actions to simple actions, is discussed further in Section 8.1.

We can now conclude the definitions supporting the validity of a plan with durative actions.

Definition 19 Executability of a Plan A plan, P (for a planning instance), is executable if the induced simple plan for P, simplify(P) **is executable, producing the trace**
{Si = (ti, si, vi)}i=0...k.

Definition 20 Validity of a Plan A plan, P **(for a planning instance), is valid if it is**
executable and if the goal specification is satisfied in the final state produced by its induced simple plan.

## 8.1 Durative Actions With Conditional Effects

We now explain how the mapping described in the previous section is extended to deal with durative actions containing conditional effects.

First, we observe that temporally annotated conditions and effects can be accumulated, because the temporal annotation distributes through logical conjunction. Therefore, we can convert conditional effects so that their conditions are simple conjunctions of at most one at start condition, at most one at end condition and at most one over all **condition. It**
should be noted that we do not allow logical connectives other than conjunction in combining temporally annotated propositions. Allowing other connectives would create **significant**
further complexity in the semantics and create potentially paradoxical opportunities for communication from future states to earlier states. Similarly to conditions, durative action effects can be reduced to a conjunction of at most one at start effect and at most one **at end**
effect. Treatment of conditional effects then divides into three cases. The **first case is very**
straightforward: any effect in a durative action of the form (when (at t p) (at t q)),
where the condition and the effect bear the same single temporal annotation, can be transformed into a simple conditional effect of the form (when p q) **attached to the start or end**
simple action according to whether t is start or end**. Since this case is straightforward we**
will not explicitly extend the previous definitions to cope with it. The second case is one in which the condition of a condition effect has at start conditions and the effect has **at end** effects.

Note that we consider conditional effects in which the effects occur at the start, but with conditions dependent on the state at the end or over the duration of the action, to be