
## 2. Pddl **Background**

pddl is an action-centred language, inspired by the well-known strips **formulations of**
planning problems. At its core is a simple standardisation of the syntax for expressing this familiar semantics of actions, using pre- and post-conditions to describe the **applicability**
and effects of actions. The syntax is inspired by Lisp, so much of the structure of a domain description is a Lisp-like list of parenthesised expressions. An early design decision in the language was to separate the descriptions of parameterised actions that characterise domain behaviours from the description of specific objects, initial conditions and goals that characterise a problem instance. Thus, a planning problem is created by **the pairing of** a domain description with a problem description. The same domain description can be paired with many different problem descriptions to yield different planning problems in the same domain. The parameterisation of actions depends on the use of variables **that** stand for terms of the problem instance - they are instantiated to objects from a specific problem instance when an action is grounded for application. The pre- and post-conditions of actions are expressed as logical propositions constructed from predicates and **argument**
terms (objects from a problem instance) and logical connectives.

Although the core of pddl is a strips **formalism, the language extends beyond that.**
The extended expressive power includes the ability to express a type structure for the objects in a domain, typing the parameters that appear in actions and constraining the types of arguments to predicates, actions with negative preconditions and conditional effects and the use of quantification in expressing both pre- and post-conditions. These extensions are essentially those proposed as adl **(Pednault, 1989).**
Although the original definition of the pddl **syntax was not accompanied by a formal semantics, the language was really a proposal for a standard syntax for a commonly accepted**
semantics and there was little scope for disagreement about the meaning of the language constructs. Two parts of the original language proposal for which this claim fails are an attempt to offer a standard syntax for describing hierarchical domain descriptions, suitable for htn **planners and the subset of the language concerned with expressing numeric-valued**
fluents. The former was an ambitious project to construct a syntax in which **the entire structure of domains using hierarchical action decompositions could be expressed. In contrast to**
strips**-based planning, the differences between planners using hierarchical decomposition**
appear to be deeper, with domain descriptions often containing structures that go beyond the description of domain behaviours (for example, shop **(Nau, Cao, Lotem, & Mu˜nozAvila, 1999) often uses mechanisms that represent goal agendas and other solution-oriented**
structures in a domain encoding). This diversity undermined the efforts at standardisation in hierarchical domain descriptions and this part of the language has never been successfully explored.

The syntax proposed for expressing numeric-valued fluents was not tested in the first use of the language (in the 1998 competition) and, indeed, it underwent revision in the early development of the language. The second competition in 2000 also avoided use of numericvalued fluents, so a general agreement about the syntax and semantics of the numericexpressivity of the language remained unnecessary. McDermott's original pddl **provides**
support for numbers by allowing numeric quantities to be assigned and updated. The syntax of numeric-valued fluents changed between the pddl **manuals 1.1 and 1.2 (McDermott &**