
## 9. The Semantics Of Continuous Durative Actions

The introduction of continuous durative actions complicates the semantics. It is no longer possible to handle invariants by insertion of simple actions between other happenings in a plan to test their continued satisfaction. In fact, continuous effects can, in principle, cause an invariant to be satisfied over some parts of an interval and not over others. Ignoring invariants for a moment, updates to numeric values caused by continuous effects can be applied as discrete updates at time points within the interval over which they apply. These updates behave slightly differently to the discrete updates we have seen in durative actions with discrete effects, since it is **possible for a continuous update to affect a variable that is**
concurrently affected by a discrete update, or examined by a precondition, without creating an inconsistency. For example, if the water heating action in Figure 14 is applied with the concurrent addition of an egg to the pan with a precondition that the temperature of the water is between 90 and 95 degrees then the value of the temperature can be examined at the moment of application of the action adding the egg. This is because the temperature change is actually happening over the interval between the start of the heating and the point at which the egg is added, rather than as a discrete update at the point the egg is added. The temperature is not actually changed at the instant of the addition of the egg.

In this section we summarise the semantics for continuous actions. Where the semantics for discrete durative actions is defined in terms of the familiar state-transition **semantics,**
the continuous semantics introduces a different formulation.

Definition 21 A Continuous Durative Action A continuous effect is an effect expression that includes the symbol \#t. A continuous durative action **is a durative action with at**
least one continuous effect.

Definition 22 Continuous Update Function Let C **be a set of ground continuous effects** for a planning instance, I, and St = (t, S, X) be a state. The **continuous update function**
defined by C for state St **is the function** fC : R → R
n, where n is dimI **, such that:**

$${\frac{d f_{C}}{d t}}=g$$
$$\mathbb{Q}\,)\,\in\,C\,\mathbb{P}$$
$${\mathsf{p}}\!\!>{\mathsf{\nabla}}{\mathsf{P}}\quad({\mathsf{\nabla}}{\mathsf{\nabla}})$$
$|\;\;\cup\;\;\subset$  . 
$\mathbf{v}$
and
$$f_{C}(0)=\mathbf{X}$$

where g is the update function generated for an action a **with:**

$${\mathfrak{p}}^{>}\setminus{\mathfrak{p}}\setminus{\mathfrak{p}}$$

$${\boldsymbol{\varepsilon}}={\boldsymbol{\varepsilon}}$$

NPa = { (<op> P Q) | (<op> P (* \#t Q)) ∈ C}
Definition 22 shows how the continuous effects of several continuous durative **actions can**
be combined to create a single system of simultaneous differential equations **whose solution,**
given an appropriate starting point, defines the evolution of the continuously varying values.

Definition 23 Induced Continuous Plan Let I **be a planning instance that includes**
continuous durative actions and P be a plan for I. The induced continuous plan for P **is a** triple, (S, Invs, Cts), where S is simplify(P), Invs is the set of **invariant constraints**:
Invs = {(Q, t, t + d)|(t, a[d]) ∈ P and (over all Q) **is an invariant for** A}