From a semantic point of view, invariants must be checked at every point in the interval over which they apply. When the interval contains only finitely many discrete changes then the obligation can be met by considering only the finite number of points at which change occurs (a fact that is exploited for discrete durative action plan semantics in Definition 18). When there is continuous change the obligation is much harder to meet. In practice, the invariants can be checked by examining the possible roots of the function describing continuous change, but finding those roots can be very difficult in general. Again, suitable constraints on the forms of differential equations expressed in a domain can make the validation problem tractable.

The last two definitions simply assemble the components to arrive at analogous definitions to those for executability and validity of simple plans and plans with durative actions.

Definition 26 Executability of a Plan A plan P **containing continuous durative actions,**
for planning instance I, with induced continuous plan (S, Invs, Cts). P is executable **if the**
trace for P **is defined,** {Si}i=0...k+1**, and it is invariant safe.**
Definition 27 Plan Validity A plan P **containing durative actions, for planning instance**
I is valid **if it is executable, with trace** {Si}i=0...k+1 and Sk+1 **satisfies the goal in** I.

## 10. Plan Validation

Plan validation is an important part of the use of pddl**, particularly in its role for the**
competition. With approximately 5000 plans to consider in the competition in 2002, **it can**
be seen that automation is essential. The validation problem is tractable for propositional versions of pddl **because plans are finite and can be validated simply by simulation of their** execution. The issue is more complicated for pddl2.1 **because the potential for concurrent**
activity, possibly in the face of numeric change, makes it necessary to ensure that invariant properties are protected and that concurrent activity is non-interfering.

When durative actions are used there is a question over whether a plan should be considered valid if it does not contain all of the end points of the actions initiated in the plan. When an action is exploited in a plan for the effect it has at the end of its duration it is clear that that end point will be present in the plan, but when an action **was selected** for its start effect this is less clear. A match-striking action is performed for its start effect, not in order to have a burned out match at the end of a brief interval. It could **be argued** that, having obtained the desired start effect the end of the action is irrelevant and the plan can terminate (as soon as all goals are achieved) without ensuring that all initiated actions end safely. Indeed, the plan search process in Sapa (Do & Kambhampati, 2001) can terminate whilst there are still queued events awaiting the advancement **of time. However,** it is possible to conceive of situations in which the end point of an action, incorporated only for its start effect, introduces inconsistencies in the plan so that its **inclusion would** make the plan invalid. In these cases it seems that plan validity could be compromised by ignoring end effects.

In order to avoid having to resolve these complexities, we have taken the view that a pddl2.1 **plan is valid only if all action start and end points are explicit within the plan.**
Having identified that this is the case we then proceed to confirm that all happenings within the plan are mutex-free.