Plan validation is decidable for domains including discretized and, under certain constraints, continuous durative actions because all activity is encapsulated with the durative actions explicitly identified by a plan. This makes the trace induced by **a plan finite and**
hence checkable. We therefore observe that the validation problem for pddl2.1 **is decidable**
even when actions contain duration inequalities. This is because the work in determining how the duration inequalities should be solved has already been completed **in the finished** plan so validation of the plan can proceed by simulation of its execution, as is the **case**
for pddl **plans. The problem is tractable for domains without continuous effects, but the**
introduction of continuous effects can, in principle, allow expression **of domains with very** complex functions describing numeric change (Howey & Long, 2002). Under the assumption that continuous effects are restricted to description in terms of simple linear or quadratic functions, without any interactions between concurrent continuous effects, plan validity is tractable. The cost in practice is increased however, since it may be necessary to solve polynomials in order to check invariants. Validation of plans containing more complex expressions of change is being explored.

Although plan validity checking is tractable, there is a subtlety that arises **because of**
the need to represent plans syntactically and the difficulties involved **in expressing numbers with arbitrary precision. In principle, all of the values that are required to describe**
valid plans are algebraic (assuming we constrain continuous effects as indicated **above),** and therefore finitely representable. In practice, expecting planners to **handle numbers as**
algebraic expressions seems unnecessarily complicated and it is far more reasonable to assume that numbers will be represented as finite precision floating point values. Indeed, the syntax we have adopted for the expression of plans restricts planners to expressing times as finite precision floating point values. With this constraint, and because of **limitations on**
the precision of floating point computations in implementations of plan validation systems, it is necessary to take a more pragmatic view of the validation process and accept **that**
numeric conditions will have to be evaluated to a certain tolerance. Otherwise, it can occur that there is no way to report a plan to the necessary degree of accuracy for it **to have a**
valid interpretation under the semantics we defined in Section 8. In most cases, a plan that specifies time points to, for example, four significant digits, is a reasonable abstraction of the execution time activity that will be needed to control the flow system. No plan **can specify** time points absolutely precisely, so abstraction is forced upon the planner by the fact that it is working with models of the world and not the physical world itself. **The problem, then,** is one of the relationship between the theoretical semantics and the pragmatic concerns of automated validation.

In Figure 18 this relationship is depicted in terms of what kinds of plans can be automatically validated. The left side of the picture describes the theoretical **semantics, with**
the arrow indicating the link between plans and their interpretation under **the theoretical**
semantics. For example, it is possible to construct a domain and problem for **which a plan**
that requires an action to happen at time √**2 is a meaningful semantic object, but for which**
a plan that specifies that the action happen at time 1.**41 is not a meaningful semantic object**
because 1.41 is not equal to √**2. These two plans are distinct, and only one is correct (under**
the assumed constraints). The right side of the picture depicts the pragmatic validation of syntactic plan objects. The two control plans, though distinct in the semantics, can map to the same syntactic object if we assume that the validation is subject to a tolerance of 0.01.