strongly influenced by the intervals approach (Muscettola, 1994; Rabideau, Knight, Chien, Fukunaga, & Govindjee, 1999). Allen later moved away from his initial position that instants are not required, introducing the notion of moments **(Hayes & Allen, 1987), which are a**
concept that attempts to reconcile the stance that nothing is instantaneous (so there **should** only be intervals) and the observation that changes in values of discrete-valued variables, such as propositional variables, apparently cannot avoid changing at instants. This view is consistent with the approach we take in the modelling of continuous durative actions, and with the view of change as consisting of both discrete and continuous aspects (Henzinger, 1996).

In the remainder of this section we compare the pddl **extensions that we propose with**
previous work in temporal reasoning by considering the three central issues identified above.

Our objective is not to claim that our extensions improve on previous work, **but instead to**
demonstrate that the implementation of solutions to these three problems within the **pddl**
framework makes their exploitation directly accessible to planning in a way that they are not when embedded within a logic and accompanying proof theory.

## 11.1 Continuous Change

Several temporal reasoning frameworks began with consideration of discrete change and, later, were extended to handle continuous change. For example, Shanahan (1990) extended the event calculus of Kowalski and Sergot (1986) to enable the modelling of continuous change. This process of extension mirrors the situation faced in extending pddl**, where a**
system modelling discrete change already existed. It is, therefore, interesting to compare the use of pddl2.1 **with the use of systems such as the extended event calculus.**
In his sink-filling example Shanahan (1990) discusses the issues of termination of events
(self-termination and termination by other events), identification of the level **of water in the**
sink during the filling process and the effect on the rate of change in the level of water in a sink when it is being filled from two sources simultaneously. The behaviour of the filling process and its effects on the state of the sink over time are modelled as axioms **which would** allow an inference engine to predict the state of the sink at points during **the execution of**
the process.

pddl2.1 **allows the representation of the complex interactions that arise when a sink is**
filled from multiple independently controlled water sources by means **of concurrent durative** actions with continuous effects that encapsulate the initiation of the filling process, from a single water source, the change in the level of water in the sink and the termination of the process when the water source is turned off. This model is robust, since it easily accommodates multiple water sources, simply modifying the rate of flow appropriately by commutative updates. Since the actions have additive effects and the model provides the rate at which water enters the tank from a source, it is possible to compute the level of water in the sink at any point in the filling interval at which a concurrent action might consult the level. In contrast to Shanahan's extension to the event calculus, this approach does not require that the filling process be (at least from the point of view of the logical axiomatisation) terminated and restarted at a new rate when a water source is opened or closed, since the process simply remains active throughout. The change in **rate of filling is**