importantly, consider that it would be impossible to use a plan of this sort as **an instruction**
to an executive - no executive could be equipped to execute actions simultaneously and yet in a specified order. Our view is that if the order of execution matters then the executive must ensure that the actions are sequenced and can only do so within the limitations of its capability to measure time and react to its passing.

Shanahan (1999) discusses Gelfond's (1991) example of the soup bowl in which the problem concerns raising a soup bowl without spilling the soup. Two actions, lift left and lift right, can be applied to the bowl. If either is applied on its own the soup will spill, but, it is argued, if they are applied simultaneously then the bowl is raised from the table and no soup spills. Shanahan considers this example within the event calculus, where he uses an explicit assertion of the interaction between the lift left and lift right actions to ensure that the spillage effect is cancelled when the pair is executed together. The assumption is that the two actions can be executed at precisely the same moment and that the reasoner can rely on the successful simultaneity in order to exploit the effect.

In pddl2.1 **we take the view that precise simultaneity is outside the control of any**
physical executive. A plan is interpreted as an instruction to some executive system and we hold that no executive system is capable of measuring time and controlling **its activity** at arbitrarily fine degrees of accuracy. In particular, it is not possible for an **executive to**
ensure that two actions that must be independently initiated are executed simultaneously. If a plan were to rely on such precision in measurement then, we claim, **it could not be** executed with any reliable expectation of success and should not, therefore, be considered a valid plan.

pddl2.1 **supports the modelling of the soup bowl situation in the following way. Two**
durative actions, lift left and lift right**, both independently initiate tilting intervals which,** when complete, will result in spillage of the soup if their effects have not been counteracted.

Provided that the two lift actions start within an appropriate tolerance of one another the tilting will be corrected and the spillage avoided without the need to model cancellation of effects. We argue that an executive can execute the two actions to within a fine but non-zero tolerance of one another, and can therefore successfully lift the bowl. The event calculus model presented by Shanahan insists on precise synchronization of the two actions, incorrectly allowing it to be inferred that the soup will be spilled even if the time that elapses between the two lifts is actually small enough to allow for correction of the tilting of the bowl. Worse, Shanahan's axioms would allow lack of precise synchronization to be exploited to achieve spillage, using an amount of time smaller than that correctly describing the physical situation being modelled.

If one considers it unnecessary to model the precise interaction between the two lifts, one has the alternative in pddl2.1 **to abstract out the interaction and see the soup-bowl**
lifting action as a single discretized action that achieves the successful **raising of the bowl.**

## 11.3 Temporal Extent

A common concern in temporal reasoning frameworks, discussed in detail by **Vila and** others (Vila, 1994; van Bentham, 1983), is the divided instant problem**. This is the problem** that is apparent when considering what happens at the moment of transition from, say, truth to falsity of a propositional variable. The question that must be addressed is whether