(define (domain jug-pouring)
(:requirements :typing :fluents)
(:types jug)
(:functors
(amount ?j -jug)
(capacity ?j -jug)
- (fluent number))
(:action empty
:parameters (?jug1 ?jug2 - jug) :precondition (fluent-test
(>= (- (capacity ?jug2) (amount ?jug2))
(amount ?jug1)))
:effect (and (change (amount ?jug1) 0)
(change (amount ?jug2)
(+ (amount ?jug1) (amount ?jug2)))))
)
Figure 1: Pouring water between jugs as described in the AI Magazine article (McDermott, 2000).

the AIPS-98 Planning Competition Committee, 1998) and the later AI Magazine article on pddl **(McDermott, 2000). McDermott presented a version of numeric fluents used in** pddl **in the article in AI Magazine (2000) which could be taken as a definitive statement of**
the syntax. An example using numeric fluents, presented by McDermott (2000), is shown in Figure 1. This action models an action from the well-known jugs-and-water **problem,**
allowing the water in one jug to be emptied into a second jug provided that **the space in** the second jug is large enough to hold the water in the first. The effect is a discrete update of the values of the current contents of the jugs by an assignment (denoted here by the change **token).**
Even without the numeric extensions, pddl **is an expressive language, capable of capturing a wide variety of interesting and challenging behaviours. Figure 2 illustrates how**
pddl **can be used to capture a domain in which a vehicle can move between locations,**
consuming fuel as it does so.

It can be seen in the example that pddl **includes a syntactic representation of the level**
of expressivity required in particular domain descriptions through the use of requirements flags. This gives the opportunity for a planning system to gracefully reject attempts to plan with domains that make use of more advanced features of the language than the planner can handle. Syntax checking tools can be used to confirm that the requirements flags are correctly set for a domain and that the types and other features of the language are correctly employed. An example of a problem description to accompany the vehicle domain is shown in Figure 3. The example illustrates that the description of an **initial** state requires an exhaustive listing of all the (atomic) propositions that hold. Symmetric or transitive relations must be modelled by exhaustive and explicit listing of the propositions that hold. The use of domain axioms to simplify the description of domains that use such relationships has been considered, but remains an untested part of pddl **and therefore**