that IxTeT uses to represent planning domains is similar to pddl2.1 **as described in this**
paper, but more expressive because it allows access to time points within the interval of a durative action. This added expressive power is obtained at the cost of increased semantic complexity and, consequently, increased difficulty in the validation of plans. However, there are many similarities between the modelling of discretised durative actions in pddl2.1 and in IxTeT, and similar modelling conventions are also found in the languages of **Sapa (Do &** Kambhampati, 2001) and Oplan (Drabble & Tate, 1994).

One of the earliest planners to consider the use of metric time was Deviser (Vere, 1983),
which was developed from nonlin **(Tate, 1977). In Deviser, metric constraints on the times**
at which actions could be applied and deadlines for the achievements of goals were both expressible and the planner could construct plans respecting metric **temporal constraints**
on the interactions between actions. Cesta and Oddi (1996) have explored various developments of temporal constraint network algorithms to achieve efficient implementation for planning and Galipienso and Sanchis (2002) consider extensions to manage disjunctive temporal constraints efficiently, which is a particularly valuable expressive element for plan construction as was observed above, since constraints preventing overlap of intervals translate into disjunctive constraints on time points. hsts **(Muscettola, 1994) also relies on a**
temporal constraint manager.

In systems that use continuous real-valued time it is possible to make use of linear constraint solvers to handle temporal constraints. In particular, constraints dictated by the relative placement of actions with durations on a timeline can be approached **in this** way (Long & Fox, 2003a). An alternative timeline that is often used is a discretised line based on integers. The advantage of this approach is that it is possible to advance time to a next value after considering activity at any given time point. The next **modality can**
be interpreted in a continuous time framework by taking it to mean the state following the next logical change, regardless of the time at which this occurs (Bacchus & Kabanza, 1998).

In planning problems in which no events can occur other than the actions dictated by the planner and no continuous change is modelled, plans are finite structures **and therefore**
change can occur at only a finite number of time points during its execution. This makes it possible to embed the execution of the plan into the integer-valued discrete time line without any loss of expressiveness.

Various researchers have considered the problem of modelling continuous change. Pednault (1986) proposes explicit description of the functions that govern the continuous change of metric parameters, attached to actions that effect instantaneous change to initiate the processes. However, his approach is not easy to use in describing interacting continuous processes. For example, if water is filling a tank at a constant rate and then an **additional** water source is added to increase the rate of filling then the action initiating the **second** process must combine the effects of the two water sources. This means that the second action cannot be described simply in terms of its direct effect on the world **— to increase** the rate of flow into the tank - but with reference to the effects of other actions that have already affected the rate of change of the parameter. Shanahan (1990) also uses this approach, with the consequence that processes are modelled as stopping and then restarting with new trajectories as each interacting action is applied.

In Zeno (Penberthy & Weld, 1994), actions have effects that are described in terms of derivatives. This approach makes it easier to describe interacting processes, but complicates