
## Appendix A. Bnf Specification Of **Pddl2.1**

This appendix contains a complete BNF specification of the pddl2.1 **language. This is not**
a strict superset of pddl1.**x. For example, the use of local variables within action schemas**
has been left out of this specification. It is not a widely used part of the language and has not been used in any of the competition domains. The interpretation of local variables as proposed by McDermott is subtle, since it demands confirmation that a unique **instantiation** exists for each such variable. It is non-trivial to confirm that this is the case during plan validation for domains with significant expressive power and the fact that it **has been largely** ignored suggests that it is poorly understood. Other changes are discussed in the following sections.

## A.1 Domains

Domain structures remain essentially as specified in pddl1.**x. The main alterations are**
to introduce a slightly modified syntax for numeric fluent expressions **and to remove the** syntax for hierarchical expansions. The latter is not necessarily abandoned, but it has not, to the best of our knowledge, been used in any publicly available planning systems or even domains. In the original pddl specification, a distinction was drawn between strict **pddl** and non-strict pddl, where strict pddl **must follow the ordering of the fields specified below,** while non-strict pddl **is not restricted in this way. In practice, there are relatively few fields**
that it is intuitive to accept in arbitrary orders - it is natural to expect declarations to precede use of symbols and for preconditions to precede effects. However, declarations of constants, predicates and function symbols are not naturally ordered, so in the current definition of pddl **the ordering of all fields must follow the specification below, with the**
exception of these three fields which are legal in any order with respect to one another, although the group must follow types (if there are any) and precede action specifications.

| <domain>                                                                                                                                                                                                                                                                                                                                                                                                        | ::= (define (domain <name>) [<require-def>] [<types-def>]:typing [<constants-def>] [<predicates-def>] [<functions-def>]:fluents <structure-def>∗)   |
|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------|
| <require-def>                                                                                                                                                                                                                                                                                                                                                                                                   | ::= (:requirements <require-key>+)                                                                                                                  |
| <require-key>                                                                                                                                                                                                                                                                                                                                                                                                   | ::= See Section A.5                                                                                                                                 |
| <types-def>                                                                                                                                                                                                                                                                                                                                                                                                     | ::= (:types <typed list (name)>)                                                                                                                    |
| <constants-def>                                                                                                                                                                                                                                                                                                                                                                                                 | ::= (:constants <typed list (name)>)                                                                                                                |
| <predicates-def>                                                                                                                                                                                                                                                                                                                                                                                                | ::= (:predicates <atomic formula skeleton>+)                                                                                                        |
| <atomic formula skeleton> ::= (<predicate> <typed list (variable)>) <predicate> ::= <name> <variable> ::= ?<name> <atomic function skeleton> ::= (<function-symbol> <typed list (variable)>) <function-symbol> ::= <name> <functions-def> ::=:fluents (:functions <function typed list (atomic function skeleton)>) <structure-def> ::= <action-def> <structure-def> ::=:durative−actions <durative-action-def> |                                                                                                                                                     |
