A slight modification has been made to the type syntax - it is no longer possible to nest either expressions (a possibility that was never exploited, but complicates **parsing).** Numbers are no longer considered to be an implicit type - the extension to **numbers is now** handled only through functional expressions. This ensures that there are only finitely many ground action instances. A desirable consequence is that action selection choice points need never include choice over arbitrary numeric ranges. The use of finite ranges of integers for specifying actions is useful (see Mystery or FreeCell for example) and an extension of the standard syntax to allow for a more convenient representation of these cases could be useful. The syntax of function declarations allows functions to be declared with types. At present the syntax is restricted to number types, since we do not have **a semantics for other**
functions, but the syntax offers scope for possible extension. Where types are not given for the function results they are assumed to be numbers.

<typed list (x)> ::= x
∗

<typed list (x)> ::=:typing x
+- <type> <typed list(x)>
<primitive-type> ::= <name>
<type> ::= (either <primitive-type>+)
<type> ::= <primitive-type>
<function typed list (x)> ::= x
∗

<function typed list (x)> ::=:typing x
+- <function type>
<function typed list(x)>
<function type> ::= number

## A.2 Actions

The BNF for an action definition is given below. Again, this has been simplified **by removing**
generally unused constructs (mainly hierarchical expansions). It should be emphasised that this removal is not intended to be a permanent exclusion - hierarchical **expansion syntax** has proved a difficult element of the language both to agree on and to exploit. As the other levels of the language stabilise we hope to return to this layer and redevelop it.

<action-def> ::= (:action <action-symbol>
:parameters ( <typed list (variable)> )
<action-def body>)
<action-symbol> ::= <name>
<action-def body> ::= [:precondition <GD>]
[:effect <effect>]
Goal descriptions have been extended to include fluent expressions.

<GD> ::= () <GD> ::= <atomic formula(term)>
<GD> ::=:negative−preconditions <literal(term)> <GD> ::= (and <GD>∗)

$$\begin{array}{l}{{\mathbf{\tau}:\mathbf{\tau}=}}\\ {{\mathbf{\tau}:\mathbf{\tau}=\mathbf{\tau}(\mathrm{~and~\epsilon<GD>^{*}~})}}\end{array}$$
