considered convenient, provided it was at least as long as the time taken to walk between the locations at the fastest walking speed possible. Constraints that do not specify the exact duration of a durative action might prove harder to handle, so we have **introduced a**
label (:duration-inequalities**) to signal that a domain makes use of them. A duration** constraint is supplied to dictate or limit the temporal extent of the durative action. The duration is an implicit parameter of the durative action and must be supplied in a plan that uses durative actions. To denote this, a durative action is denoted in a plan by t:(name arg1...argn)[d] where d **is the (non-negative, rational valued) duration in** floating point format (n.n**). Duration constraints can be explicitly temporally annotated to** indicate that they should be evaluated in the context of the start or end point of the action, or else they can be left unannotated, in which case the default is that they are **evaluated in** the context at the start of the action (as indicated in Definition 16).

<duration-constraint> ::= :duration−inequalities
 : : := $\sqrt[]{\mathrm{duration}-\mathrm{ln}\mathrm{quantif}}$ (and <simple-duration-constraint>${}^{+}$) : := ( )   : := <simple-duration-constraint>   : := (<d-op> ?duration <d-value>)   : := (at <time-speciferr>   > <simple-duration-constraint>)   : :=$\sqrt[]{\mathrm{duration}-\mathrm{ln}\mathrm{quantif}}$ <=   : :=$\sqrt[]{\mathrm{duration}-\mathrm{ln}\mathrm{quantif}}$ >=   : :=$\sqrt[]{\mathrm{duration}-\mathrm{ln}\mathrm{quantif}}$ >=  
$$i_{\mathrm{{T}}}t$$
$\star\star$. 
<duration-constraint> ::= ()
<duration-constraint> ::= <simple-duration-constraint> <simple-duration-constraint> ::= (<d-op> ?duration <d-value>) <simple-duration-constraint> ::= (at <time-specifier>
<d-op> ::=:duration−inequalities <= <d-op> ::=:duration−inequalities >=
<d-op> ::= =
<d-value> ::= <number>
<d-value> ::=:fluents <f-exp>
In addition to logical effects, which can occur at the start or end of a durative action, durative actions can have numeric effects that refer to the literal ?duration**. More sophisticated durative actions can also make use of functional expressions describing effects that**
occur over the duration of the action. This allows functional expressions to be updated by a continuous function of time, rather than only step functions.

Note that the ?duration **term can only be used to define functional expression updating**
effects if the duration constraints requirement is set. This is because in **other cases the** duration value is available as an expression, whereas when duration constraints are provided the duration can, sometimes, be freely selected within constrained boundaries.

$$\begin{array}{r l}{{\mathrm{\tan{\mathrm{-effects}}}}}&{{}({\mathrm{~w}})}\\ {a}&{{}(<\!\!\!{\mathtt{a s s i g n\!-\!c}}\\ {}&{{}<\!\!\!{\mathtt{t i m e\!-\!s p e c}}}\end{array}$$

<da-effect> ::= ()

<da-effect> ::= (and <da-effect>∗)

<da-effect> ::= <timed-effect>

<da-effect> ::=:conditional−effects (forall (<variable>∗) <da-effect>) <da-effect> ::=:conditional−effects (when <da-GD> <timed-effect>)

<da-effect> ::=:fluents (<assign-op> <f-head> <f-exp-da>)

<timed-effect> ::= (at <time-specifier> <a-effect>)

<timed-effect> ::= (at <time-specifier> <f-assign-da>)

<timed-effect> ::=:continuous−effects (<assign-op-t> <f-head> <f-exp-t>)

<f-assign-da> ::= (<assign-op> <f-head> <f-exp-da>)

<f-exp-da> ::= (<binary-op> <f-exp-da> <f-exp-da>)

<f-exp-da> ::= (- <f-exp-da>)

<f-exp-da> ::=:duration−inequalities ?duration

<f-exp-da> ::= <f-exp>

