
| <assign-op-t>   | ::= increase       |
|-----------------|--------------------|
| <assign-op-t>   | ::= decrease       |
| <f-exp-t>       | ::= (* <f-exp> #t) |
| <f-exp-t>       | ::= (* #t <f-exp>) |
| <f-exp-t>       | ::= #t             |

The symbol \#t **is used to represent the period of time that a given durative action has**
been active. It is therefore a local **clock value for each duration, independent of similar** clocks for each other duration. There has been discussion with members of **the committee** about the use of the expression using \#t**: it was proposed that an expression declaring** the rate of change alone could be used. We decided against this on the grounds that the assertion of a rate of change suggests that the rate of change is determined by one process effect alone. In fact, it is intended that if multiple active processes affect the same fluent then these effects are accumulated. Using the expression that directly defines the amount by which each process contributes to the change in a fluent value over time **we do not appear**
to assert (inconsistently) that a fluent has multiple simultaneous rates of change.

## A.4 Problems

Planning problems specifications have been modified to exclude several generally unused constructs (named initial situations and expansion information). We have removed the length specification because it is at odds with the intention to supply physics, not advice.

Furthermore, the advice this field offers over-emphasises a very coarse **plan metric. Instead,** we have introduced an optional metric field, which can be used to supply an **expression that**
should be optimized in the construction of a plan. The field states whether the metric is to be minimized or maximized. Of course, a planner is free to ignore this **field and make**
the assumption that plans with fewest steps will be considered good plans. **However, we** consider this extension to be a crucial one in the development of a more widely applicable planning language. We have provided the variable total-time **that takes the value of the** total execution time for the plan. This allows us to conveniently express the intention to minimize total execution time.

We anticipate that extensions of the plan metric syntax will prove necessary in the longer term, but believe that this version already provides a significant **new challenge to**
the community. Problem specifications are still somewhat impoverished **in terms of the**
ability to easily specify temporal constraints on goals and other non-standard features of initial and goal states. Again, we anticipate the need for extension, but have chosen **to leave**
a clean sheet for future developments.

<problem> ::= (define (problem <name>)
(:domain <name>)
[<require-def>] [<object declaration> ]
<init>
<goal>
[<metric-spec>]
[<length-spec> ])
<object declaration> ::= (:objects <typed list (name)>)
<init> ::= (:init <init-el>∗)
<init-el> ::= <literal(name)>