(define (domain vehicle)
(:requirements :strips :typing)
(:types vehicle location fuel-level)
(:predicates (at ?v - vehicle ?p - location)
(fuel ?v - vehicle ?f - fuel-level)
(accessible ?v - vehicle ?p1 ?p2 - location)
(next ?f1 ?f2 - fuel-level))
(:action drive
:parameters (?v - vehicle ?from ?to - location
?fbefore ?fafter - fuel-level)
:precondition (and (at ?v ?from)
(accessible ?v ?from ?to)
(fuel ?v ?fbefore)
(next ?fbefore ?fafter))
:effect (and (not (at ?v ?from))
(at ?v ?to)
(not (fuel ?v ?fbefore))
(fuel ?v ?fafter))
)
)
Figure 2: A domain description in **pddl**.

an unstable part of the syntax. pddl **domains are not case-sensitive, which is somewhat**
anachronistic in the light of standard practice in modern programming languages.

In the following sections we review the extensions made to pddl **in its development into**
pddl2.1**, the version of the language used in the third International Planning Competition.**

## 3. Numeric Expressions, Conditions And Effects

One of the first decisions we made in the development of pddl2.1 **was to propose a definitive**
syntax for the expression of numeric fluents. We based our syntax on the version described in the AI Magazine article (McDermott, 2000), with some minor revisions (discussed below). Numeric expressions are constructed, using arithmetic operators, from primitive numeric expressions, which are values associated with tuples of domain objects by domain functions. Using our proposed syntax for expressing numeric assignments and updates we can express the jug-pouring operator originally described in the pddl1.2 **manual and in the AI** Magazine article (see Figure 1), in pddl2.1**, as presented in Figure 4. In this example the**
functions capacity and amount associate the jug objects with numeric values corresponding to their capacity and current contents respectively. As can be seen in **the example,**
we have used a prefix syntax for all arithmetic operators, including comparison predicates, in order to simplify parsing. Conditions on numeric expressions are always comparisons between pairs of numeric expressions. Effects can make use of a selection of assignment operations in order to update the values of primitive numeric expressions. **These include** direct assignment and relative assignments (such as increase and decrease**). Numbers** are not distinguished in their possible roles, so values can represent, for example, quantities of resources, accumulating utility, indices or counters.