The differences between the pddl2.1 **syntax and the AI Magazine syntax are in the**
declaration of the functions and in the use of assign **instead of** change**. We decided** to only allow numeric-valued functions, making the declaration of function return types superfluous. We therefore simplified the language by requiring only the declaration of the function names and argument types, as is required for predicates. We felt that change was ambiguous when used alongside the operations increase and decrease **and that** assign would be clearer.

Numeric expressions are not allowed to appear as terms in the language (that is, as arguments to predicates or values of action parameters). There are two justifications for this decision - a philosophical one and a pragmatic one. Philosophically we take the view that there are only a finite number of objects in the world. Numbers do not **exist as** unique and independent objects in the world, but only as values of attributes of objects.

Our models are object-oriented in the sense that all actions can be seen as methods that apply to the objects given as their parameters. The object-oriented view does **not directly**
inform the syntax of our representations, but is reflected in the way in which numbers are manipulated only through their relationships with the objects that are identified and named in the initial state. Pragmatically, many current planning approaches rely on **being able** to instantiate action schemas prior to planning, and this is only feasible if there is a finite number of action instances. The branching of the planner's search space, at **choice points**
corresponding to action selection, is therefore always over finite ranges. The use of numeric fluent variables conflicts with this because they could occur as arguments to any predicate and would not define finite ranges.

Our decision not to allow numbers to be used as arguments to actions rules out **some**
actions that might seem intuitively reasonable. For example, an action to fly **at a certain** altitude might be expected to take the altitude as a number-valued argument. This is only possible in pddl2.1 **if the range of numbers that can be used is finite. From a practical**
point of view we think that this is unlikely to be an arduous constraint and that the benefits of keeping the logical state space finite compensates for any modelling awkwardness that results.

Functions in pddl2.1 are restricted to be of type Objectn → R, for the (finite) collection of objects in a planning instance, Object and finite function arity n**. Later extensions**
of pddl might introduce functions of type Objectn → Object, allowing Object **to be extended by the application of functions to other objects. The advantage of this would be**
to allow objects to be referred to by their relationships to known objects. **(For example,**
(onTopOf ?x) could be used to refer to the object currently on top of an object instantiating ?x**). Unfortunately, such functions present various semantic problems. In particular,**
the interpretation of quantified preconditions becomes significantly harder, **since the collection of objects is no longer necessarily finite, so extensional interpretations are not possible.**
A further difficulty is the identity problem - as objects are manipulated by **actions, the** functional expressions that refer to them are also affected, but implicitly. For example, as objects are moved, (onTopOf A) **can change without any action manipulating it explicitly.** Managing the way in which functional terms map to specific objects in the domain **(which** might or might not have specific names of their own) appears to introduce considerable complication into the semantics. We believe that it is important to avoid extending **pddl**
with elements that are still poorly understood.